/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.cim.provider.rs6k;

import com.ibm.hsc.cim.exceptions.HSCCIMException;
import com.ibm.hsc.cim.provider.rs6k.AsynchEventManager;
import com.ibm.hsc.cim.provider.rs6k.AsynchEventQueueMgr;
import com.ibm.hsc.cim.provider.rs6k.CimomWrapper;
import com.ibm.hsc.cim.provider.rs6k.ComputerSystemProvUtils;
import com.ibm.hsc.cim.provider.rs6k.FrameUtils;
import com.ibm.hsc.cim.provider.rs6k.HscCimObjUtils;
import com.ibm.hsc.cim.provider.rs6k.HscInfoInstProv;
import com.ibm.hsc.cim.provider.rs6k.HscInfoMethProv;
import com.ibm.hsc.cim.provider.rs6k.HscProviderUtils;
import com.ibm.hsc.cim.provider.rs6k.NVRAM;
import com.ibm.hsc.cim.provider.rs6k.SNIAdapterUpdater;
import com.ibm.hsc.cim.provider.rs6k.indication.server.HSCEventQueue;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.common.util.HSCVPD;
import com.ibm.hsc.common.util.HscConstants;
import com.ibm.hsc.common.util.HscProviderSocket;
import com.ibm.hsc.common.util.ProviderLceCommunication;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.common.util.VersionComparator;
import com.ibm.hsc.security.HscPermission;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.snia.wbem.cim.CIMClass;
import org.snia.wbem.cim.CIMDataType;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;
import org.snia.wbem.client.CIMOMHandle;
import org.snia.wbem.client.ProviderCIMOMHandle;
import org.snia.wbemcfg.GlobalConfig;

public class CecUpdater {
    private CIMOMHandle cimHandle = null;
    private CIMObjectPath cecObjPath;
    private CIMInstance oldCecInst;
    private CIMInstance cecInst;
    private String cecName;
    private String cspVersion;
    private short cecState;
    private int runtimeCap;
    private int CecCapability;
    private short cecMode;
    private boolean dlparCap = false;
    private int rebuildFlag;
    private boolean cecModified = false;
    private boolean sockFlag = false;
    private boolean hasSmp = false;
    private CIMInstance addedFrameCecAssoInst = null;
    private CIMInstance deletedFrameCecAssoInst = null;
    private int frameEvent = 0;
    private CIMInstance frameInst = null;
    private SNIAdapterUpdater smaUpdater;
    private HSCEventQueue eventQueue;
    private Hashtable runningLpars;
    private Hashtable fastActivateLpars;
    private short numOfLpars;
    private NVRAM nvram = null;
    static final short DLPAR_BIT = 16;
    static final short CUOD_BIT = 64;
    static final short MESSAGE_PASSING_CAPABLE = 32;
    static final String CONSOLE_KEY_NAME = "Name";
    static final int LPAR_INFO_USER_DEF_NAME = 0;
    static final int LPAR_INFO_PHYSICAL_LOC_CODE = 1;
    static final int LPAR_INFO_CLUSTER_TYPE = 2;
    public static final int UPDATE_FROM_CREATE_CEC = 0;
    public static final int UPDATE_FROM_REBUILD = 1;
    public static final int UPDATE_FROM_POWER_ON = 2;
    private static final boolean DEBUG_ON = true;

    public CecUpdater(CIMOMHandle cIMOMHandle, CIMObjectPath cIMObjectPath, CIMInstance cIMInstance, int n) {
        this.cimHandle = cIMOMHandle;
        this.cecObjPath = cIMObjectPath;
        this.oldCecInst = cIMInstance;
        this.cecInst = this.oldCecInst.filterProperties(null, true, true);
        this.rebuildFlag = n;
        try {
            this.cecName = (String)cIMInstance.getProperty(CONSOLE_KEY_NAME).getValue().getValue();
            this.cecName = this.cecName.trim();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this.eventQueue = new HSCEventQueue();
        this.smaUpdater = new SNIAdapterUpdater(this.cimHandle, this.cecObjPath, this.cecInst);
    }

    public CIMObjectPath update() throws CIMException {
        HscProviderSocket hscProviderSocket = null;
        return this.update(hscProviderSocket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CIMObjectPath update(HscProviderSocket hscProviderSocket) throws CIMException {
        String string;
        Hashtable hashtable;
        boolean bl;
        HscProviderSocket hscProviderSocket2;
        block108: {
            block105: {
                CIMObjectPath cIMObjectPath;
                block106: {
                    hscProviderSocket2 = hscProviderSocket;
                    Object var3_3 = null;
                    Object var4_4 = null;
                    Object var5_5 = null;
                    this.addedFrameCecAssoInst = null;
                    this.deletedFrameCecAssoInst = null;
                    Trace.trace("apcshscT", "-> CecUpdater-invokemethod");
                    if (!HscProviderUtils.checkPermission(new HscPermission("hsc", HscPermission.HSC_ACTION_BUILDHSC), null)) {
                        System.out.println(" access denied...");
                        throw new HSCCIMException("1584");
                    }
                    if (this.rebuildFlag != 2) {
                        AsynchEventManager.stopOpPanelPoller(this.cecName);
                    }
                    AsynchEventQueueMgr.initMgr(this.cimHandle, this.cecObjPath, this.cecName, false);
                    if (this.cecInst == null) {
                        throw new HSCCIMException("157F");
                    }
                    if (!ProviderLceCommunication.isRegistered(this.cecName)) {
                        System.out.println("connection not registered, register now ");
                        ProviderLceCommunication.registerConnection(this.cecName);
                    }
                    if (hscProviderSocket2 == null) {
                        hscProviderSocket2 = ProviderLceCommunication.obtainSocket(this.cecName);
                        this.sockFlag = true;
                    }
                    bl = false;
                    if (this.rebuildFlag == 0) {
                        this.cecObjPath = ComputerSystemProvUtils.createCECInst(this.cimHandle, hscProviderSocket2, this.cecObjPath, this.cecInst);
                    }
                    try {
                        hashtable = null;
                        hashtable = HscProviderUtils.doCSPCommand("SET_LOCK_VALUE", new String[]{Integer.toHexString(1), HscProviderUtils.getHscID(this.cimHandle)}, hscProviderSocket2);
                        bl = true;
                        System.out.println("++++++got csp lock");
                        this.resetAsyncEventMask(hscProviderSocket2);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        throw new CIMException("Unable to get CSP Lock");
                    }
                    if (this.rebuildFlag == 0) {
                        hashtable = HscProviderUtils.doCSPCommand("GET_CEC_NAME", null, hscProviderSocket2);
                        string = (String)hashtable.get("CEC_NAME");
                        this.cecInst.setProperty("UserDefinedName", new CIMValue((Object)string));
                    }
                    hashtable = HscProviderUtils.doCSPCommand("GET_CSP_INTERFACE_VERSION_NUMBER", null, hscProviderSocket2);
                    this.cspVersion = (String)hashtable.get("VERSION");
                    System.out.println("The CSP version is :" + this.cspVersion);
                    string = ComputerSystemProvUtils.getHMCVersion(this.cimHandle);
                    System.out.println("The HMC version is :" + string);
                    if (string.equals("R4V3.0")) {
                        System.out.println("The HMC version is BOGUS!!!!!!!");
                        string = "R4V1.0";
                    }
                    System.out.println("++++++Checking the version compatibility");
                    boolean bl2 = VersionComparator.isCompatible(string, this.cspVersion);
                    if (bl2) break block105;
                    this.cecInst.setProperty("state", new CIMValue((Object)new UnsignedInt8(250)));
                    CimomWrapper.setInstance(this.cimHandle, this.cecObjPath, this.cecInst);
                    this.cecModified = true;
                    CIMObjectPath cIMObjectPath2 = this.updateFrameInstance(this.cecName, 0, false, 4);
                    this.updateFrameCecAss(cIMObjectPath2);
                    cIMObjectPath = this.cecObjPath;
                    if (this.cecInst != null) break block106;
                    throw new HSCCIMException("157F");
                }
                try {
                    block107: {
                        try {
                            if (this.rebuildFlag != 2) {
                                AsynchEventManager.startOpPanelPoller(this.cimHandle, this.cecObjPath, this.cecName);
                            }
                            if (this.frameInst != null) {
                                if (this.frameEvent == 1) {
                                    this.eventQueue.add(this.frameEvent, this.frameInst, null);
                                } else if (this.frameEvent == 4) {
                                    this.eventQueue.add(this.frameEvent, this.frameInst, this.frameInst);
                                }
                            }
                            if (this.cecModified) {
                                if (this.rebuildFlag == 0) {
                                    this.eventQueue.add(1, this.cecInst, null);
                                } else {
                                    this.eventQueue.add(4, this.cecInst, this.cecInst);
                                }
                            }
                            if (!this.hasSmp) {
                                CIMInstance cIMInstance = null;
                                try {
                                    cIMInstance = CimomWrapper.getInstance(this.cimHandle, this.cecObjPath, this.cimHandle.getClass(this.cecObjPath, false), false);
                                }
                                catch (Throwable throwable) {
                                    System.out.println("The CEC is not created: " + this.cecName);
                                }
                                if (cIMInstance != null) {
                                    System.out.println("++++++++Oops, need to create full system partition");
                                    this.createSmpPartition(hscProviderSocket2);
                                }
                            }
                            if (this.deletedFrameCecAssoInst != null) {
                                this.eventQueue.add(2, this.deletedFrameCecAssoInst, null);
                            }
                            if (this.addedFrameCecAssoInst != null) {
                                this.eventQueue.add(1, this.addedFrameCecAssoInst, null);
                            }
                            this.eventQueue.send();
                            if (!bl) break block107;
                            HscProviderUtils.doCSPCommand("SET_LOCK_VALUE", new String[]{Integer.toHexString(2), HscProviderUtils.getHscID(this.cimHandle)}, hscProviderSocket2);
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                            Object var15_30 = null;
                            if (!this.sockFlag) return cIMObjectPath;
                            if (hscProviderSocket2 == null) return cIMObjectPath;
                            hscProviderSocket2.releaseLock();
                            return cIMObjectPath;
                        }
                    }
                    Object var15_29 = null;
                    if (!this.sockFlag || hscProviderSocket2 == null) return cIMObjectPath;
                    hscProviderSocket2.releaseLock();
                    return cIMObjectPath;
                }
                catch (Throwable throwable) {
                    Object var15_31 = null;
                    if (!this.sockFlag || hscProviderSocket2 == null) throw throwable;
                    hscProviderSocket2.releaseLock();
                    throw throwable;
                }
            }
            if (this.rebuildFlag == 0) {
                this.setPollFreq(hscProviderSocket2);
            }
            this.updateCecInstance(hscProviderSocket2);
            this.createSmpPartition(hscProviderSocket2);
            this.hasSmp = true;
            if (this.rebuildFlag == 0) {
                this.createHscInfo(hscProviderSocket2);
            } else {
                this.pushHscInfo(hscProviderSocket2);
            }
            this.nvram = null;
            try {
                this.nvram = new NVRAM(this.cecName, hscProviderSocket2, this.cspVersion);
            }
            catch (Throwable throwable) {
                this.nvram = null;
                throwable.printStackTrace();
                System.out.println("++++++ excep in the nvram initilize ..");
            }
            if (this.nvram == null) {
                System.out.println("++++++ failed to initilize the nvram");
                if (this.cecState != 12 && this.cecState != 15) {
                    this.cecInst.setProperty("state", new CIMValue((Object)new UnsignedInt8(251)));
                    this.cecState = (short)251;
                    CimomWrapper.setInstance(this.cimHandle, this.cecObjPath, this.cecInst);
                    HscProviderUtils.handleCecInCompleteState(this.cimHandle, this.cecInst, this.cecInst, hscProviderSocket2);
                }
                this.updateFrame(this.CecCapability, hscProviderSocket2);
            } else {
                String[] stringArray = this.nvram.getAllPartitionNames(hscProviderSocket2);
                this.numOfLpars = (short)stringArray.length;
                int n = VersionComparator.CSPVersionValue(this.cspVersion);
                this.updatePartitions(hscProviderSocket2, n, this.nvram);
                this.updateSystemProfiles(hscProviderSocket2, this.nvram);
                this.updateFrame(this.CecCapability, hscProviderSocket2);
                if (this.dlparCap) {
                    System.out.println("calling lspartition!");
                    boolean bl3 = false;
                    try {
                        String string2 = this.cecName.replace('*', '_');
                        Process process = Runtime.getRuntime().exec("/opt/hsc/bin/lspartition -c " + string2 + " -dlparreset");
                        System.out.println("...Done!");
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        System.out.println("lspartition call failed!");
                        HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
                    }
                }
            }
            short s = ((UnsignedInt8)this.cecInst.getProperty("State").getValue().getValue()).shortValue();
            if (s == 251) {
                System.out.println("++++++In recovery state!");
            }
            if (this.cecInst != null) break block108;
            throw new HSCCIMException("157F");
        }
        try {
            block109: {
                try {
                    if (this.rebuildFlag != 2) {
                        AsynchEventManager.startOpPanelPoller(this.cimHandle, this.cecObjPath, this.cecName);
                    }
                    if (this.frameInst != null) {
                        if (this.frameEvent == 1) {
                            this.eventQueue.add(this.frameEvent, this.frameInst, null);
                        } else if (this.frameEvent == 4) {
                            this.eventQueue.add(this.frameEvent, this.frameInst, this.frameInst);
                        }
                    }
                    if (this.cecModified) {
                        if (this.rebuildFlag == 0) {
                            this.eventQueue.add(1, this.cecInst, null);
                        } else {
                            this.eventQueue.add(4, this.cecInst, this.cecInst);
                        }
                    }
                    if (!this.hasSmp) {
                        hashtable = null;
                        try {
                            hashtable = CimomWrapper.getInstance(this.cimHandle, this.cecObjPath, this.cimHandle.getClass(this.cecObjPath, false), false);
                        }
                        catch (Throwable throwable) {
                            System.out.println("The CEC is not created: " + this.cecName);
                        }
                        if (hashtable != null) {
                            System.out.println("++++++++Oops, need to create full system partition");
                            this.createSmpPartition(hscProviderSocket2);
                        }
                    }
                    if (this.deletedFrameCecAssoInst != null) {
                        this.eventQueue.add(2, this.deletedFrameCecAssoInst, null);
                    }
                    if (this.addedFrameCecAssoInst != null) {
                        this.eventQueue.add(1, this.addedFrameCecAssoInst, null);
                    }
                    this.eventQueue.send();
                    if (!bl) break block109;
                    HscProviderUtils.doCSPCommand("SET_LOCK_VALUE", new String[]{Integer.toHexString(2), HscProviderUtils.getHscID(this.cimHandle)}, hscProviderSocket2);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    Object var17_35 = null;
                    if (!this.sockFlag) return this.cecObjPath;
                    if (hscProviderSocket2 == null) return this.cecObjPath;
                    hscProviderSocket2.releaseLock();
                    return this.cecObjPath;
                }
            }
            Object var17_34 = null;
            if (!this.sockFlag || hscProviderSocket2 == null) return this.cecObjPath;
            hscProviderSocket2.releaseLock();
            return this.cecObjPath;
        }
        catch (Throwable throwable) {
            Object var17_36 = null;
            if (!this.sockFlag || hscProviderSocket2 == null) throw throwable;
            hscProviderSocket2.releaseLock();
            throw throwable;
        }
        catch (Throwable throwable) {
            block110: {
                try {
                    Trace.trace("apcshscT", "Exception in reb1uiding of cec");
                    throwable.printStackTrace(System.out);
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
                    if (this.cecInst == null) {
                        try {
                            this.cecInst = CimomWrapper.getInstance(this.cimHandle, this.cecObjPath, this.cimHandle.getClass(this.cecObjPath, false), false);
                        }
                        catch (Throwable throwable2) {
                            System.out.println("CEC not created: " + this.cecName);
                        }
                    }
                    if (this.cecInst != null) {
                        if (((UnsignedInt8)this.cecInst.getProperty("State").getValue().getValue()).shortValue() != 251) {
                            System.out.println("++++++++cec state incomplete");
                            this.cecInst.setProperty("State", new CIMValue((Object)new UnsignedInt8(253)));
                            CimomWrapper.setInstance(this.cimHandle, this.cecObjPath, this.cecInst);
                        }
                        HscProviderUtils.handleCecInCompleteState(this.cimHandle, this.cecInst, this.cecInst, hscProviderSocket2);
                        this.updateFrame(this.CecCapability, hscProviderSocket2);
                    }
                    if (this.cecInst != null) break block110;
                    throw new HSCCIMException("157F");
                }
                catch (Throwable throwable3) {
                    if (this.cecInst == null) {
                        throw new HSCCIMException("157F");
                    }
                    try {
                        block112: {
                            try {
                                if (this.rebuildFlag != 2) {
                                    AsynchEventManager.startOpPanelPoller(this.cimHandle, this.cecObjPath, this.cecName);
                                }
                                if (this.frameInst != null) {
                                    if (this.frameEvent == 1) {
                                        this.eventQueue.add(this.frameEvent, this.frameInst, null);
                                    } else if (this.frameEvent == 4) {
                                        this.eventQueue.add(this.frameEvent, this.frameInst, this.frameInst);
                                    }
                                }
                                if (this.cecModified) {
                                    if (this.rebuildFlag == 0) {
                                        this.eventQueue.add(1, this.cecInst, null);
                                    } else {
                                        this.eventQueue.add(4, this.cecInst, this.cecInst);
                                    }
                                }
                                if (!this.hasSmp) {
                                    CIMInstance cIMInstance = null;
                                    try {
                                        cIMInstance = CimomWrapper.getInstance(this.cimHandle, this.cecObjPath, this.cimHandle.getClass(this.cecObjPath, false), false);
                                    }
                                    catch (Throwable throwable4) {
                                        System.out.println("The CEC is not created: " + this.cecName);
                                    }
                                    if (cIMInstance != null) {
                                        System.out.println("++++++++Oops, need to create full system partition");
                                        this.createSmpPartition(hscProviderSocket2);
                                    }
                                }
                                if (this.deletedFrameCecAssoInst != null) {
                                    this.eventQueue.add(2, this.deletedFrameCecAssoInst, null);
                                }
                                if (this.addedFrameCecAssoInst != null) {
                                    this.eventQueue.add(1, this.addedFrameCecAssoInst, null);
                                }
                                this.eventQueue.send();
                                if (!bl) break block112;
                                HscProviderUtils.doCSPCommand("SET_LOCK_VALUE", new String[]{Integer.toHexString(2), HscProviderUtils.getHscID(this.cimHandle)}, hscProviderSocket2);
                            }
                            catch (Throwable throwable5) {
                                throwable5.printStackTrace();
                                Object var24_47 = null;
                                if (!this.sockFlag || hscProviderSocket2 == null) throw throwable3;
                                hscProviderSocket2.releaseLock();
                                throw throwable3;
                            }
                        }
                        Object var24_46 = null;
                        if (!this.sockFlag || hscProviderSocket2 == null) throw throwable3;
                        hscProviderSocket2.releaseLock();
                        throw throwable3;
                    }
                    catch (Throwable throwable6) {
                        Object var24_48 = null;
                        if (!this.sockFlag || hscProviderSocket2 == null) throw throwable6;
                        hscProviderSocket2.releaseLock();
                        throw throwable6;
                    }
                }
            }
            try {
                block111: {
                    try {
                        if (this.rebuildFlag != 2) {
                            AsynchEventManager.startOpPanelPoller(this.cimHandle, this.cecObjPath, this.cecName);
                        }
                        if (this.frameInst != null) {
                            if (this.frameEvent == 1) {
                                this.eventQueue.add(this.frameEvent, this.frameInst, null);
                            } else if (this.frameEvent == 4) {
                                this.eventQueue.add(this.frameEvent, this.frameInst, this.frameInst);
                            }
                        }
                        if (this.cecModified) {
                            if (this.rebuildFlag == 0) {
                                this.eventQueue.add(1, this.cecInst, null);
                            } else {
                                this.eventQueue.add(4, this.cecInst, this.cecInst);
                            }
                        }
                        if (!this.hasSmp) {
                            string = null;
                            try {
                                string = CimomWrapper.getInstance(this.cimHandle, this.cecObjPath, this.cimHandle.getClass(this.cecObjPath, false), false);
                            }
                            catch (Throwable throwable7) {
                                System.out.println("The CEC is not created: " + this.cecName);
                            }
                            if (string != null) {
                                System.out.println("++++++++Oops, need to create full system partition");
                                this.createSmpPartition(hscProviderSocket2);
                            }
                        }
                        if (this.deletedFrameCecAssoInst != null) {
                            this.eventQueue.add(2, this.deletedFrameCecAssoInst, null);
                        }
                        if (this.addedFrameCecAssoInst != null) {
                            this.eventQueue.add(1, this.addedFrameCecAssoInst, null);
                        }
                        this.eventQueue.send();
                        if (!bl) break block111;
                        HscProviderUtils.doCSPCommand("SET_LOCK_VALUE", new String[]{Integer.toHexString(2), HscProviderUtils.getHscID(this.cimHandle)}, hscProviderSocket2);
                    }
                    catch (Throwable throwable8) {
                        throwable8.printStackTrace();
                        Object var19_39 = null;
                        if (!this.sockFlag) return this.cecObjPath;
                        if (hscProviderSocket2 == null) return this.cecObjPath;
                        hscProviderSocket2.releaseLock();
                        return this.cecObjPath;
                    }
                }
                Object var19_38 = null;
                if (!this.sockFlag || hscProviderSocket2 == null) return this.cecObjPath;
                hscProviderSocket2.releaseLock();
                return this.cecObjPath;
            }
            catch (Throwable throwable9) {
                Object var19_40 = null;
                if (!this.sockFlag || hscProviderSocket2 == null) throw throwable9;
                hscProviderSocket2.releaseLock();
                throw throwable9;
            }
        }
    }

    public void updateCecInstance(HscProviderSocket hscProviderSocket) throws CIMException {
        String string;
        int n;
        Object object;
        Hashtable hashtable = null;
        short s = -1;
        short s2 = -1;
        long l = -1L;
        int n2 = -1;
        Integer n3 = null;
        boolean bl = false;
        System.out.println("=========In updateCecInstance");
        int n4 = this.cecName.indexOf(42);
        String string2 = this.cecName.substring(0, n4);
        String string3 = this.cecName.substring(n4 + 1);
        if (CimomWrapper.setProperty(this.cecInst, "SerialNumber", string3)) {
            bl = true;
            System.out.println("++++++SerialNumber updated: " + string3);
        }
        if (CimomWrapper.setProperty(this.cecInst, "Model", string2)) {
            bl = true;
            System.out.println("++++++Model updated: " + string2);
        }
        hashtable = HscProviderUtils.getCapabilities(this.cspVersion, hscProviderSocket);
        this.runtimeCap = (Integer)hashtable.get("RuntimeCapability");
        this.CecCapability = (Integer)hashtable.get("CecCapability");
        this.cspVersion = ComputerSystemProvUtils.checkCSPVersionSpoofing(this.CecCapability, this.cspVersion, hscProviderSocket, this.cimHandle);
        this.cecMode = ((Integer)hashtable.get("CecMode")).shortValue();
        System.out.println("THE RUNTIME CAPABILITY IS : " + this.runtimeCap);
        System.out.println("THE DLPAR BIT IS : 16");
        if ((this.runtimeCap & 0x10) != 0) {
            System.out.println("Is DLPAR Capable ***************");
            if (CimomWrapper.setPropertyString(this.cecInst, "CSPVersion", this.cspVersion)) {
                bl = true;
                System.out.println("++++++CSPVersion updated: " + this.cspVersion);
            }
            this.dlparCap = true;
        } else {
            System.out.println("Is NOT DLPAR Capable ***************");
            if (CimomWrapper.setPropertyString(this.cecInst, "CSPVersion", this.cspVersion)) {
                bl = true;
                System.out.println("++++++CSPVersion updated: " + this.cspVersion);
            }
        }
        int n5 = 0;
        if ((this.runtimeCap & 0x40) != 0) {
            hashtable = HscProviderUtils.doCSPCommand("GET_CUOD_CAPABILITIES", null, hscProviderSocket, this.cspVersion);
            n5 = (Integer)hashtable.get("CUOD_CAPABILITIES");
            System.out.println("++++++++cuodCapability = " + n5);
        }
        if (CimomWrapper.setProperty(this.cecInst, "CUoDCapabilities", new UnsignedInt16(n5))) {
            System.out.println("++++++++cuodCapability updated: " + n5);
            bl = true;
        }
        if (CimomWrapper.setProperty(this.cecInst, "Capability", new UnsignedInt16(this.CecCapability))) {
            System.out.println("++++++++CecCapability updated: " + this.CecCapability);
            bl = true;
        }
        if (CimomWrapper.setProperty(this.cecInst, "RuntimeCapability", new UnsignedInt16(this.runtimeCap))) {
            System.out.println("++++++++runtimeCap updated: " + this.runtimeCap);
            bl = true;
        }
        hashtable = HscProviderUtils.doCSPCommand("GET_CEC_STATE", null, hscProviderSocket);
        this.cecState = ((Integer)hashtable.get("CEC_STATE")).shortValue();
        if (CimomWrapper.setProperty(this.cecInst, "State", new UnsignedInt8(this.cecState))) {
            bl = true;
            System.out.println("+++++++++++the cec state updated: " + this.cecState);
        }
        if (CimomWrapper.setProperty(this.cecInst, "Mode", new UnsignedInt8(this.cecMode))) {
            bl = true;
            System.out.println("+++++++++++the cec mode updated: " + this.cecMode);
        }
        if (this.cecState == 1) {
            hashtable = HscProviderUtils.doCSPCommand("GET_CEC_RESOURCES", null, hscProviderSocket);
            n3 = (Integer)hashtable.get("NUM_PROCESSORS");
            s = n3.shortValue();
            n3 = (Integer)hashtable.get("NUM_IO_DRAWERS");
            s2 = n3.shortValue();
            object = (Long)hashtable.get("MEMORY");
            l = (Long)object;
            if (CimomWrapper.setProperty(this.cecInst, "InstalledCPUCount", new UnsignedInt8(s))) {
                System.out.println("++++++++InstalledCPUCount updated: " + s);
                bl = true;
            }
            if (CimomWrapper.setProperty(this.cecInst, "IODrawerCount", new UnsignedInt8(s2))) {
                System.out.println("++++++++IODrawerCount updated: " + s2);
                bl = true;
            }
            if (CimomWrapper.setProperty(this.cecInst, "InstalledMemory", new UnsignedInt32(l))) {
                System.out.println("++++++++InstalledMemory updated: " + l);
                bl = true;
            }
        }
        if (CimomWrapper.setProperty(this.cecInst, "LPARSlotCount", new UnsignedInt16((n3 = (Integer)(hashtable = HscProviderUtils.doCSPCommand("GET_NUM_LPAR_SLOTS", null, hscProviderSocket)).get("NUM_LPAR_SLOTS")).intValue()))) {
            System.out.println("++++++++LPARSlotCount updated: " + n3);
            bl = true;
        }
        object = new String[]{Integer.toHexString(1)};
        hashtable = HscProviderUtils.doCSPCommand("GET_CEC_POLICY_SETTINGS", (String[])object, hscProviderSocket);
        n3 = (Integer)hashtable.get("POWER_POLICY");
        n2 = n3.shortValue();
        CIMValue cIMValue = null;
        cIMValue = n2 == 0 ? CIMValue.FALSE : CIMValue.TRUE;
        if (CimomWrapper.setPropertyCIMValue(this.cecInst, "PowerOffPolicy", cIMValue)) {
            System.out.println("++++++++PowerOffPolicy updated: " + cIMValue);
            bl = true;
        }
        if (this.rebuildFlag != 0) {
            Integer n6;
            int n7 = 0;
            if (VersionComparator.CSPVersionValue(this.cspVersion) < 3000) {
                hashtable = HscProviderUtils.doCSPCommand("GET_HSC_POLLING_FREQUENCY", null, hscProviderSocket);
                n6 = (Integer)hashtable.get("POLL_FREQUENCY");
                n7 = n6;
            } else {
                hashtable = HscProviderUtils.doCSPCommand("GET_HSC_POLLING_FREQUENCY", null, hscProviderSocket, this.cspVersion);
                n6 = (Integer)hashtable.get("REPORT_TIMEOUTS_VALUE");
                n = n6;
                n7 = n == 1 ? HscConstants.HSC_CSP_POLLING_FREQUENCY.intValue() : 0;
            }
            if (CimomWrapper.setProperty(this.cecInst, "CspSurveillancePolicy", new UnsignedInt16(n7))) {
                System.out.println("++++++++CspSurvaillancePolicy updated: " + n7);
                bl = true;
            }
        }
        if (CimomWrapper.setPropertyString(this.cecInst, "UserDefinedName", string = (String)(hashtable = HscProviderUtils.doCSPCommand("GET_CEC_NAME", null, hscProviderSocket)).get("CEC_NAME"))) {
            System.out.println("++++++++givenCecName updated: " + string);
            bl = true;
        }
        if (this.cecState == 1 && this.cecMode == 255) {
            long l2;
            int n8 = VersionComparator.CSPVersionValue(this.cspVersion);
            if ((float)n8 >= 2000.0f) {
                n = 0;
                if (((short)this.runtimeCap & 8) == 8) {
                    hashtable = HscProviderUtils.doCSPCommand("GET_PROCESSOR_AFFINITY", null, hscProviderSocket, this.cspVersion);
                    n3 = (Integer)hashtable.get("AFFINITY_TYPE");
                    n = n3.shortValue();
                }
                if (CimomWrapper.setProperty(this.cecInst, "AffinityCapability", new UnsignedInt8((short)n))) {
                    System.out.println("++++++++affinitySupported updated: " + n);
                    bl = true;
                }
            }
            hashtable = HscProviderUtils.doCSPCommand("GET_CEC_MEMORY_RESOURCES", null, hscProviderSocket, this.cspVersion);
            Long l3 = (Long)hashtable.get("MEMORY_INSTALLED");
            long l4 = l3.shortValue();
            l3 = (Long)hashtable.get("TOT_AVAILABLE_MEMORY");
            long l5 = l3;
            l3 = (Long)hashtable.get("FAILED_MEMORY");
            long l6 = l3;
            l3 = (Long)hashtable.get("REGION_SIZE");
            long l7 = l3;
            System.out.println("++++++++++++++++the totol Mem is .." + l4);
            System.out.println("++++++++++++++++the freeMemory Mem is .." + l5);
            System.out.println("++++++++++++++++the failedMemory Mem is .." + l6);
            System.out.println("++++++++++++++++the lmbSize is .." + l7);
            if (CimomWrapper.setProperty(this.cecInst, "LMBSize", new UnsignedInt32(l7))) {
                System.out.println("++++++++++++++++the lmbSize updated: " + l7);
                bl = true;
            }
            if ((float)n8 >= 3000.0f) {
                l3 = (Long)hashtable.get("LPAR_MIN_MEM_SIZE");
                l2 = l3;
                System.out.println("++++++++++++++++the lparMinMemSize is .." + l2);
                if (CimomWrapper.setProperty(this.cecInst, "LparMinMemorySize", new UnsignedInt32(l2))) {
                    System.out.println("++++++++++++++++the lparMinMemSize updated: " + l2);
                    bl = true;
                }
            }
            l2 = l5 - l6;
            System.out.println("++++++++++++++++the usable memory is .." + l2);
            this.updateMemoryInstance(l4, l5, l2);
            hashtable = HscProviderUtils.doCSPCommand("GET_INSTALLED_PROC_STATE_VALUE", null, hscProviderSocket);
            n3 = (Integer)hashtable.get("NUM_PROCESSORS");
            int n9 = n3;
            System.out.println("++++++++the numOfProcessors ....." + n9);
            this.updateCpuInstances(hscProviderSocket, n9);
            this.updateDrawers(hscProviderSocket);
            if ((float)n8 > 3000.0f && (this.runtimeCap & 0x20) != 0) {
                this.smaUpdater.update(hscProviderSocket);
            }
        }
        if (bl) {
            CimomWrapper.setInstance(this.cimHandle, this.cecObjPath, this.cecInst);
            System.out.println("++++++ cec modified");
            this.cecModified = true;
        }
        System.out.println("++++++++end of updateCecInstance");
    }

    private void updateMemoryInstance(long l, long l2, long l3) throws CIMException {
        String string;
        CIMProperty cIMProperty;
        Object var7_4 = null;
        CIMObjectPath cIMObjectPath = null;
        boolean bl = false;
        CIMObjectPath cIMObjectPath2 = new CIMObjectPath("IBMHSC_CompSysMemory", "root/ibmhscV3_2");
        Vector vector = CimomWrapper.associators(this.cimHandle, cIMObjectPath2, this.cecObjPath, null, "GroupComponent", "PartComponent", true, true, null);
        CIMInstance cIMInstance = null;
        if (vector != null && !vector.isEmpty()) {
            Enumeration enumeration = vector.elements();
            if (enumeration.hasMoreElements()) {
                cIMInstance = (CIMInstance)enumeration.nextElement();
            }
        }
        boolean bl2 = false;
        if (cIMInstance == null) {
            cIMObjectPath = new CIMObjectPath("IBMHSC_Memory", "root/ibmhscV3_2");
            cIMProperty = this.cimHandle.getClass(cIMObjectPath, false);
            cIMInstance = cIMProperty.newInstance();
            bl2 = true;
        }
        cIMProperty = this.cecInst.getProperty(CONSOLE_KEY_NAME);
        String string2 = (String)cIMProperty.getValue().getValue();
        if (bl2) {
            cIMInstance.setProperty("TotalMemory", new CIMValue((Object)new UnsignedInt32(l)));
            cIMInstance.setProperty("FreeMemory", new CIMValue((Object)new UnsignedInt32(l2)));
            cIMInstance.setProperty("UsableMemory", new CIMValue((Object)new UnsignedInt32(l3)));
            cIMInstance.setProperty("CreationClassName", new CIMValue((Object)"IBMHSC_Memory"));
            cIMInstance.setProperty("SystemName", new CIMValue((Object)string2));
            cIMInstance.setProperty("SystemCreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
            cIMInstance.setProperty("DeviceID", new CIMValue((Object)"Mem00"));
            System.out.println("++++++++create memory instance: " + cIMInstance);
            bl = true;
        } else {
            System.out.println("++++++++memory instance found: " + cIMInstance);
            if (CimomWrapper.setProperty(cIMInstance, "TotalMemory", new UnsignedInt32(l))) {
                bl = true;
                System.out.println("++++++++TotalMemory updated: " + l);
            }
            if (CimomWrapper.setProperty(cIMInstance, "FreeMemory", new UnsignedInt32(l2))) {
                bl = true;
                System.out.println("++++++++FreeMemory updated: " + l2);
            }
            if (CimomWrapper.setProperty(cIMInstance, "UsableMemory", new UnsignedInt32(l3))) {
                bl = true;
                System.out.println("++++++++UsableMemory updated: " + l3);
            }
            string = Long.toString(l) + " " + Long.toString(l2) + " " + Long.toString(l3);
            System.out.println("++++++++the total,free and usable memory" + string);
            if (CimomWrapper.setPropertyString(cIMInstance, "CreationClassName", "IBMHSC_Memory")) {
                bl = true;
                System.out.println("++++++++CreationClassName updated: IBMHSC_Memory");
            }
            if (CimomWrapper.setPropertyString(cIMInstance, "SystemName", string2)) {
                bl = true;
                System.out.println("++++++++SystemName updated: " + string2);
            }
            if (CimomWrapper.setPropertyString(cIMInstance, "SystemCreationClassName", "IBMHSC_ComputerSystem")) {
                bl = true;
                System.out.println("++++++++SystemCreationClassName updated: IBMHSC_ComputerSystem");
            }
            if (CimomWrapper.setPropertyString(cIMInstance, "DeviceID", "Mem00")) {
                bl = true;
                System.out.println("++++++++DeviceID updated: Mem00");
            }
        }
        if (bl) {
            cIMObjectPath2 = new CIMObjectPath(cIMInstance.getClassName(), cIMInstance.getKeyValuePairs());
            cIMObjectPath2.setNameSpace("root/ibmhscV3_2");
            if (bl2) {
                cIMObjectPath = CimomWrapper.createInstance(this.cimHandle, cIMObjectPath2, cIMInstance);
                string = new CIMObjectPath("IBMHSC_CompSysMemory", "root/ibmhscV3_2");
                CIMInstance cIMInstance2 = this.cimHandle.getClass((CIMObjectPath)string, false).newInstance();
                cIMInstance2.setProperty("GroupComponent", new CIMValue((Object)this.cecObjPath));
                cIMInstance2.setProperty("PartComponent", new CIMValue((Object)cIMObjectPath));
                string = new CIMObjectPath(cIMInstance2.getClassName(), cIMInstance2.getKeyValuePairs());
                string.setNameSpace("root/ibmhscV3_2");
                CimomWrapper.createInstance(this.cimHandle, (CIMObjectPath)string, cIMInstance2);
            } else {
                CimomWrapper.setInstance(this.cimHandle, cIMObjectPath2, cIMInstance);
            }
        }
    }

    Hashtable getProcStatus(HscProviderSocket hscProviderSocket, String[] stringArray) {
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        String[] stringArray2 = new String[1];
        int n = 0;
        while (n < stringArray.length) {
            stringArray2[0] = stringArray[n];
            try {
                Hashtable hashtable2 = HscProviderUtils.doCSPCommand("GET_PROC_STATUS", stringArray2, hscProviderSocket);
                Integer n2 = (Integer)hashtable2.get("PROC_STATUS");
                hashtable.put(stringArray[n], n2);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            ++n;
        }
        return hashtable;
    }

    Hashtable getProcState(HscProviderSocket hscProviderSocket, String[] stringArray) {
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        String[] stringArray2 = new String[1];
        int n = 0;
        while (n < stringArray.length) {
            try {
                stringArray2[0] = stringArray[n];
                Hashtable hashtable2 = HscProviderUtils.doCSPCommand("GET_PROC_STATE", stringArray2, hscProviderSocket);
                Integer n2 = (Integer)hashtable2.get("PROC_STATE");
                hashtable.put(stringArray[n], n2);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            ++n;
        }
        return hashtable;
    }

    private void updateCpuInstances(HscProviderSocket hscProviderSocket, int n) throws CIMException {
        short s;
        Enumeration<Object> enumeration;
        ProviderCIMOMHandle providerCIMOMHandle = (ProviderCIMOMHandle)this.cimHandle;
        CIMObjectPath cIMObjectPath = null;
        CIMObjectPath cIMObjectPath2 = null;
        CIMClass cIMClass = null;
        Object var7_7 = null;
        CIMInstance cIMInstance = null;
        boolean bl = false;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = Integer.toHexString(n2);
            ++n2;
        }
        Hashtable hashtable = this.getProcStatus(hscProviderSocket, stringArray);
        Hashtable hashtable2 = this.getProcState(hscProviderSocket, stringArray);
        cIMObjectPath = new CIMObjectPath("IBMHSC_CompSysProcessor", "root/ibmhscV3_2");
        Vector vector = CimomWrapper.associators(this.cimHandle, cIMObjectPath, this.cecObjPath, null, "GroupComponent", "PartComponent", true, true, null);
        CIMInstance cIMInstance2 = null;
        if (vector != null && !vector.isEmpty()) {
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                cIMInstance2 = (CIMInstance)enumeration.nextElement();
                short s2 = ((UnsignedInt8)cIMInstance2.getProperty("DeviceID").getValue().getValue()).shortValue();
                System.out.println("++++++++ existing processor id: " + s2);
                CIMObjectPath cIMObjectPath3 = new CIMObjectPath(cIMInstance2.getClassName(), cIMInstance2.getKeyValuePairs());
                cIMObjectPath3.setNameSpace("root/ibmhscV3_2");
                if (s2 >= n) {
                    System.out.println("++++++++ no such processor: " + s2);
                    HscCimObjUtils.deleteProcessor(this.cimHandle, cIMObjectPath3, this.cecObjPath);
                    continue;
                }
                bl = false;
                String string = Integer.toHexString(s2);
                s = ((Integer)hashtable2.get(string)).shortValue();
                short s3 = ((Integer)hashtable.get(string)).shortValue();
                if (CimomWrapper.setProperty(cIMInstance2, "CPUState", new UnsignedInt8(s))) {
                    bl = true;
                    System.out.println("++++++++CPUState updated: " + s);
                }
                if (CimomWrapper.setProperty(cIMInstance2, "CPUStatus", new UnsignedInt8(s3))) {
                    bl = true;
                    System.out.println("++++++++CPUStatus updated: " + s3);
                }
                if (CimomWrapper.setPropertyString(cIMInstance2, "SystemCreationClassName", "IBMHSC_ComputerSystem")) {
                    bl = true;
                    System.out.println("++++++++SystemCreationClassName updated: IBMHSC_ComputerSystem");
                }
                if (CimomWrapper.setPropertyString(cIMInstance2, "SystemName", this.cecName)) {
                    bl = true;
                    System.out.println("++++++++SystemName updated: " + this.cecName);
                }
                if (CimomWrapper.setPropertyString(cIMInstance2, "CreationClassName", "IBMHSC_Processor")) {
                    bl = true;
                    System.out.println("++++++++CreationClassName updated: IBMHSC_Processor");
                }
                if (bl) {
                    CimomWrapper.setInstance(this.cimHandle, cIMObjectPath3, cIMInstance2);
                    System.out.println("++++++++cpu instance has been updated.");
                }
                hashtable.remove(string);
                hashtable2.remove(string);
            }
        }
        enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            int n3 = Integer.valueOf(string, 16);
            short s4 = ((Integer)hashtable2.get(string)).shortValue();
            s = ((Integer)hashtable.get(string)).shortValue();
            if (s == 0 || s == 16) {
                System.out.println("++++++ processor: " + string + " not in good state");
                continue;
            }
            System.out.println("++++++++ creating new cpu instance");
            System.out.println("++++++++ new process id: " + n3);
            CIMObjectPath cIMObjectPath4 = new CIMObjectPath("IBMHSC_Processor", "root/ibmhscV3_2");
            cIMClass = providerCIMOMHandle.getClass(cIMObjectPath4, false);
            CIMInstance cIMInstance3 = cIMClass.newInstance();
            cIMInstance3.setProperty("DeviceID", new CIMValue((Object)new UnsignedInt8((short)n3)));
            cIMInstance3.setProperty("CPUState", new CIMValue((Object)new UnsignedInt8(s4)));
            cIMInstance3.setProperty("CPUStatus", new CIMValue((Object)new UnsignedInt8(s)));
            cIMInstance3.setProperty("SystemCreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
            cIMInstance3.setProperty("SystemName", new CIMValue((Object)this.cecName));
            cIMInstance3.setProperty("CreationClassName", new CIMValue((Object)"IBMHSC_Processor"));
            cIMObjectPath2 = new CIMObjectPath(cIMInstance3.getClassName(), cIMInstance3.getKeyValuePairs());
            cIMObjectPath2.setNameSpace("root/ibmhscV3_2");
            CIMObjectPath cIMObjectPath5 = CimomWrapper.createInstance(this.cimHandle, cIMObjectPath2, cIMInstance3);
            cIMObjectPath = new CIMObjectPath("IBMHSC_CompSysProcessor", "root/ibmhscV3_2");
            cIMClass = providerCIMOMHandle.getClass(cIMObjectPath, false);
            cIMInstance = cIMClass.newInstance();
            cIMInstance.setProperty("GroupComponent", new CIMValue((Object)this.cecObjPath));
            cIMInstance.setProperty("PartComponent", new CIMValue((Object)cIMObjectPath5));
            cIMObjectPath2 = new CIMObjectPath(cIMInstance.getClassName(), cIMInstance.getKeyValuePairs());
            cIMObjectPath2.setNameSpace("root/ibmhscV3_2");
            CimomWrapper.createInstance(this.cimHandle, cIMObjectPath2, cIMInstance);
        }
    }

    private void updateDrawers(HscProviderSocket hscProviderSocket) throws CIMException {
        String string;
        Object object;
        String[] stringArray;
        String string2;
        Enumeration enumeration;
        Object object2;
        Serializable serializable;
        Object object3;
        ProviderCIMOMHandle providerCIMOMHandle = (ProviderCIMOMHandle)this.cimHandle;
        Properties properties = null;
        Properties properties2 = null;
        Hashtable hashtable = null;
        Hashtable hashtable2 = null;
        Integer n = null;
        int n2 = -1;
        String string3 = null;
        short s = -1;
        CIMObjectPath cIMObjectPath = null;
        CIMObjectPath cIMObjectPath2 = null;
        CIMClass cIMClass = null;
        CIMInstance cIMInstance = null;
        Object var15_15 = null;
        boolean bl = false;
        hashtable = HscProviderUtils.doCSPCommand("GET_NUM_IO_DRAWERS", null, hscProviderSocket);
        System.out.println("++++++++the response for the get num of IO draw ..." + hashtable);
        n = (Integer)hashtable.get("NUM_IO_DRAWERS");
        int n3 = n.shortValue();
        System.out.println("++++++++The num of IO drawer's is ..." + n3);
        String[] stringArray2 = (String[])hashtable.get("DRAWER_IDS");
        HashSet<String> hashSet = new HashSet<String>();
        int n4 = 0;
        while (n4 < n3) {
            hashSet.add(stringArray2[n4]);
            ++n4;
        }
        int n5 = VersionComparator.CSPVersionValue(this.cspVersion);
        if (properties == null) {
            try {
                properties = new Properties();
                properties2 = new Properties();
                object3 = null;
                serializable = null;
                object2 = null;
                enumeration = null;
                object3 = new File("/opt/hsc/data/HscPciClassCodeInfo");
                enumeration = new FileInputStream((File)object3);
                serializable = new File("/opt/hsc/data/HSCVendorLookUp");
                object2 = new FileInputStream((File)serializable);
                properties.load((InputStream)((Object)enumeration));
                properties2.load((InputStream)object2);
                ((FileInputStream)object2).close();
                ((FileInputStream)((Object)enumeration)).close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                String string4 = " The Properties File HscPciClassCodeInfo is not available";
                fileNotFoundException.printStackTrace();
                HSCLogUtils.serverLog(fileNotFoundException, HSCLogUtils._LPARClassLogInfo);
                throw new HSCCIMException("0219");
            }
            catch (IOException iOException) {
                System.out.println(" IOError : Failed during the Properties  Initialization of the class code.");
                iOException.printStackTrace();
                HSCLogUtils.serverLog(iOException, HSCLogUtils._LPARClassLogInfo);
                throw new HSCCIMException("021A");
            }
            catch (Exception exception) {
                System.out.println(" excep in initization of class  code property file... but Continue!!!");
                System.out.println(exception.getMessage());
                HSCLogUtils.serverLog(exception, HSCLogUtils._LPARClassLogInfo);
                exception.printStackTrace();
                throw new HSCCIMException("021B");
            }
        }
        if ((serializable = CimomWrapper.associators(this.cimHandle, object3 = new CIMObjectPath("IBMHSC_CompSysIODrawer", "root/ibmhscV3_2"), this.cecObjPath, null, "GroupComponent", "PartComponent", true, true, null)) != null && !serializable.isEmpty()) {
            enumeration = serializable.elements();
            while (enumeration.hasMoreElements()) {
                object2 = (CIMInstance)enumeration.nextElement();
                string2 = (String)object2.getProperty("DeviceID").getValue().getValue();
                System.out.println("++++++++ existing IO Drawer id: " + string2);
                stringArray = new CIMObjectPath(object2.getClassName(), object2.getKeyValuePairs());
                stringArray.setNameSpace("root/ibmhscV3_2");
                if (!hashSet.contains(string2)) {
                    System.out.println("++++++++ no such io drawer: " + string2);
                    HscCimObjUtils.deleteDrawer(this.cimHandle, (CIMObjectPath)stringArray, this.cecObjPath);
                    continue;
                }
                object = new String[]{string2};
                hashtable = HscProviderUtils.doCSPCommand("GET_IO_DRAWER_INFO", object, hscProviderSocket);
                n = (Integer)hashtable.get("DRAWER_CLASS");
                n2 = n;
                string3 = (String)hashtable.get("DRAWER_LOC_CODE");
                string3 = string3.trim();
                n = (Integer)hashtable.get("NUM_SLOTS");
                s = n.shortValue();
                hashtable2 = (Hashtable)hashtable.get("SLOT_INFORMATION");
                bl = false;
                if (CimomWrapper.setPropertyString((CIMInstance)object2, "PhysicalLocation", string3)) {
                    bl = true;
                    System.out.println("++++++++PhysicalLocation updated: " + string3);
                }
                if (CimomWrapper.setProperty((CIMInstance)object2, "ClassCode", new UnsignedInt16(n2))) {
                    bl = true;
                    System.out.println("++++++++ClassCode updated: " + n2);
                }
                string = null;
                if (properties != null) {
                    String string5 = Integer.toString(n2);
                    string = (String)properties.get(string5);
                }
                System.out.println("the drawerClassInfo is .." + string);
                if (string == null) {
                    string = " UN_KNOWN";
                }
                if (CimomWrapper.setPropertyString((CIMInstance)object2, "Description", string)) {
                    bl = true;
                    System.out.println("++++++++Description updated: " + string);
                }
                if (CimomWrapper.setPropertyString((CIMInstance)object2, "SystemCreationClassName", "IBMHSC_ComputerSystem")) {
                    bl = true;
                    System.out.println("++++++++SystemCreationClassName updated: IBMHSC_ComputerSystem");
                }
                if (CimomWrapper.setPropertyString((CIMInstance)object2, "SystemName", this.cecName)) {
                    bl = true;
                    System.out.println("++++++++SystemName updated: " + this.cecName);
                }
                if (CimomWrapper.setPropertyString((CIMInstance)object2, "CreationClassName", "IBMHSC_IODrawer")) {
                    bl = true;
                    System.out.println("++++++++CreationClassName updated: IBMHSC_IODrawer");
                }
                if (bl) {
                    CimomWrapper.setInstance(this.cimHandle, (CIMObjectPath)stringArray, (CIMInstance)object2);
                    System.out.println("++++++++io drawer instance has been updated.");
                }
                this.updateSlots(hscProviderSocket, n5, string2, string3, hashtable2, s, properties, properties2, (CIMObjectPath)stringArray);
                hashSet.remove(string2);
            }
        }
        enumeration = hashSet.iterator();
        while (enumeration.hasNext()) {
            System.out.println("++++++++ creating new io drawer instance");
            string2 = (String)enumeration.next();
            System.out.println("++++++++ new io drawer id: " + string2);
            stringArray = new String[]{string2};
            hashtable = HscProviderUtils.doCSPCommand("GET_IO_DRAWER_INFO", stringArray, hscProviderSocket);
            n = (Integer)hashtable.get("DRAWER_CLASS");
            n2 = n;
            string3 = (String)hashtable.get("DRAWER_LOC_CODE");
            string3 = string3.trim();
            n = (Integer)hashtable.get("NUM_SLOTS");
            s = n.shortValue();
            hashtable2 = (Hashtable)hashtable.get("SLOT_INFORMATION");
            object = null;
            if (properties != null) {
                string = Integer.toString(n2);
                object = (String)properties.get(string);
            }
            System.out.println("the drawerClassInfo is .." + (String)object);
            if (object == null) {
                object = " UN_KNOWN";
            }
            cIMObjectPath = new CIMObjectPath("IBMHSC_IODrawer", "root/ibmhscV3_2");
            cIMClass = providerCIMOMHandle.getClass(cIMObjectPath, false);
            object2 = cIMClass.newInstance();
            object2.setProperty("DeviceID", new CIMValue((Object)string2));
            object2.setProperty("PhysicalLocation", new CIMValue((Object)string3));
            object2.setProperty("ClassCode", new CIMValue((Object)new UnsignedInt16(n2)));
            object2.setProperty("Description", new CIMValue(object));
            object2.setProperty("SystemCreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
            object2.setProperty("SystemName", new CIMValue((Object)this.cecName));
            object2.setProperty("CreationClassName", new CIMValue((Object)"IBMHSC_IODrawer"));
            cIMObjectPath2 = new CIMObjectPath(object2.getClassName(), object2.getKeyValuePairs());
            cIMObjectPath2.setNameSpace("root/ibmhscV3_2");
            string = CimomWrapper.createInstance(this.cimHandle, cIMObjectPath2, (CIMInstance)object2);
            this.updateSlots(hscProviderSocket, n5, string2, string3, hashtable2, s, properties, properties2, (CIMObjectPath)string);
            object3 = new CIMObjectPath("IBMHSC_CompSysIODrawer", "root/ibmhscV3_2");
            cIMClass = providerCIMOMHandle.getClass(object3, false);
            cIMInstance = cIMClass.newInstance();
            cIMInstance.setProperty("GroupComponent", new CIMValue((Object)this.cecObjPath));
            cIMInstance.setProperty("PartComponent", new CIMValue((Object)string));
            cIMObjectPath2 = new CIMObjectPath(cIMInstance.getClassName(), cIMInstance.getKeyValuePairs());
            cIMObjectPath2.setNameSpace("root/ibmhscV3_2");
            CimomWrapper.createInstance(this.cimHandle, cIMObjectPath2, cIMInstance);
        }
    }

    private void updateSlots(HscProviderSocket hscProviderSocket, int n, String string, String string2, Hashtable hashtable, short n2, Properties properties, Properties properties2, CIMObjectPath cIMObjectPath) throws CIMException {
        Hashtable hashtable2;
        Object object;
        Integer n3;
        CIMInstance cIMInstance;
        Enumeration<Object> enumeration;
        Serializable serializable;
        Object object2;
        Hashtable<Integer, Object> hashtable3 = new Hashtable<Integer, Object>();
        int n4 = 0;
        while (n4 < n2) {
            object2 = (Hashtable)hashtable.get(new Integer(n4));
            serializable = (Integer)((Hashtable)object2).get("SLOT_NO");
            hashtable3.put((Integer)serializable, object2);
            ++n4;
        }
        object2 = new CIMObjectPath("IBMHSC_IODrawerSlot", "root/ibmhscV3_2");
        serializable = CimomWrapper.associators(this.cimHandle, (CIMObjectPath)object2, cIMObjectPath, null, "GroupComponent", "PartComponent", true, true, null);
        if (serializable != null && !((Vector)serializable).isEmpty()) {
            enumeration = ((Vector)serializable).elements();
            while (enumeration.hasMoreElements()) {
                cIMInstance = (CIMInstance)enumeration.nextElement();
                short s = ((UnsignedInt8)cIMInstance.getProperty("SlotID").getValue().getValue()).shortValue();
                n3 = new Integer(s);
                System.out.println("++++++++ existing slot id: " + s);
                object = (Hashtable)hashtable3.get(n3);
                hashtable2 = new CIMObjectPath(cIMInstance.getClassName(), cIMInstance.getKeyValuePairs());
                hashtable2.setNameSpace("root/ibmhscV3_2");
                if (!hashtable3.containsKey(n3)) {
                    System.out.println("++++++++ no such slot: " + s);
                    HscCimObjUtils.deleteSlot(this.cimHandle, (CIMObjectPath)hashtable2, cIMObjectPath);
                    this.eventQueue.add(2, cIMInstance, null);
                    continue;
                }
                boolean bl = this.setSlotProperties(n, (Hashtable)object, s, string, string2, properties, properties2, cIMInstance);
                if (bl) {
                    CimomWrapper.setInstance(this.cimHandle, (CIMObjectPath)hashtable2, cIMInstance);
                }
                hashtable3.remove(n3);
            }
        }
        enumeration = hashtable3.keys();
        while (enumeration.hasMoreElements()) {
            System.out.println("++++++++ creating new slot instance");
            Integer n5 = (Integer)enumeration.nextElement();
            System.out.println("++++++++ new slot id: " + n5);
            n3 = null;
            object = new CIMObjectPath("IBMHSC_PCISlot", "root/ibmhscV3_2");
            n3 = this.cimHandle.getClass(object, false);
            cIMInstance = n3.newInstance();
            hashtable2 = (Hashtable)hashtable3.get(n5);
            this.setSlotProperties(n, hashtable2, n5.shortValue(), string, string2, properties, properties2, cIMInstance);
            object = new CIMObjectPath(cIMInstance.getClassName(), cIMInstance.getKeyValuePairs());
            object.setNameSpace("root/ibmhscV3_2");
            CIMObjectPath cIMObjectPath2 = CimomWrapper.createInstance(this.cimHandle, object, cIMInstance);
            object2 = new CIMObjectPath("IBMHSC_IODrawerSlot", "root/ibmhscV3_2");
            CIMInstance cIMInstance2 = this.cimHandle.getClass((CIMObjectPath)object2, false).newInstance();
            cIMInstance2.setProperty("GroupComponent", new CIMValue((Object)cIMObjectPath));
            cIMInstance2.setProperty("PartComponent", new CIMValue((Object)cIMObjectPath2));
            object2 = new CIMObjectPath(cIMInstance2.getClassName(), cIMInstance2.getKeyValuePairs());
            object2.setNameSpace("root/ibmhscV3_2");
            CimomWrapper.createInstance(this.cimHandle, (CIMObjectPath)object2, cIMInstance2);
        }
    }

    private boolean setSlotProperties(int n, Hashtable hashtable, short s, String string, String string2, Properties properties, Properties properties2, CIMInstance cIMInstance) throws CIMException {
        String string3;
        Object object;
        boolean bl = false;
        String string4 = (String)hashtable.get("SLOT_LOC_CODE");
        string4 = string4.trim();
        if (CimomWrapper.setPropertyString(cIMInstance, "IODrawerDeviceID", string)) {
            bl = true;
            System.out.println("++++++++ IODrawerDeviceID updated: " + string);
        }
        if (CimomWrapper.setProperty(cIMInstance, "SlotID", new UnsignedInt8(s))) {
            bl = true;
            System.out.println("++++++++ SlotID updated: " + s);
        }
        if (CimomWrapper.setPropertyString(cIMInstance, "IODrawerCreationClassName", "IBMHSC_IODrawer")) {
            bl = true;
            System.out.println("++++++++ IODrawerCreationClassName updated: IBMHSC_IODrawer");
        }
        if (CimomWrapper.setPropertyString(cIMInstance, "IODrawerSystemName", this.cecName)) {
            bl = true;
            System.out.println("++++++++ IODrawerSystemName updated: " + this.cecName);
        }
        if (CimomWrapper.setPropertyString(cIMInstance, "IODrawerSystemCreationClassName", "IBMHSC_ComputerSystem")) {
            bl = true;
            System.out.println("++++++++ IODrawerSystemCreationClassName updated: IBMHSC_ComputerSystem");
        }
        if (string2.equals("")) {
            if (string4.equals("")) {
                string4 = "UnKnown";
            }
            if (CimomWrapper.setPropertyString(cIMInstance, "SlotLocation", string4)) {
                bl = true;
                System.out.println("++++++++ SlotLocation updated: " + string4);
            }
        } else if (string4.equals("")) {
            string4 = "UnKnown";
            if (CimomWrapper.setPropertyString(cIMInstance, "SlotLocation", string4)) {
                bl = true;
                System.out.println("++++++++ SlotLocation updated: " + string4);
            }
        } else {
            object = string2.concat("-") + string4;
            if (CimomWrapper.setPropertyString(cIMInstance, "SlotLocation", (String)object)) {
                bl = true;
                System.out.println("++++++++ SlotLocation updated: " + (String)object);
            }
        }
        object = (Integer)hashtable.get("IO_STATUS");
        cIMInstance.setProperty("PCISlotStatus", new CIMValue((Object)new UnsignedInt8(((Integer)object).shortValue())));
        object = (Integer)hashtable.get("PCI_BUS_NO");
        if (CimomWrapper.setProperty(cIMInstance, "PCIBus", new UnsignedInt8(((Integer)object).shortValue()))) {
            bl = true;
        }
        if (CimomWrapper.setPropertyString(cIMInstance, "ClassCode", string3 = (String)hashtable.get("PCI_CLASS_CODE"))) {
            bl = true;
        }
        String string5 = null;
        if (properties != null) {
            string5 = (String)properties.get(string3);
        }
        if (string5 == null) {
            string5 = string3;
        }
        object = (Integer)hashtable.get("DEVICE_ID");
        Integer n2 = (Integer)hashtable.get("VENDOR_ID");
        if ((Integer)object == 65535 && n2 == 65535) {
            string5 = "Empty";
        }
        if (CimomWrapper.setProperty(cIMInstance, "DeviceId", new UnsignedInt16(((Integer)object).intValue()))) {
            bl = true;
        }
        if (CimomWrapper.setProperty(cIMInstance, "VendorID", new UnsignedInt16(n2.intValue()))) {
            bl = true;
        }
        if (CimomWrapper.setPropertyString(cIMInstance, "ClassCodeInfo", string5)) {
            bl = true;
        }
        if (CimomWrapper.setProperty(cIMInstance, "State", new UnsignedInt8(((Integer)(object = (Integer)hashtable.get("IO_STATE"))).shortValue()))) {
            bl = true;
        }
        if ((float)n >= 3000.0f) {
            long l = (Long)hashtable.get("DRC_INDEX");
            System.out.println("The DRCIndex value is :" + l);
            if (CimomWrapper.setProperty(cIMInstance, "DRCIndex", new UnsignedInt32(l))) {
                bl = true;
            }
        }
        return bl;
    }

    private void updatePartitions(HscProviderSocket hscProviderSocket, int n, NVRAM nVRAM) throws CIMException {
        CIMObjectPath cIMObjectPath;
        short s;
        Object object;
        Object object2;
        Object object3;
        Vector vector;
        ProviderCIMOMHandle providerCIMOMHandle = (ProviderCIMOMHandle)this.cimHandle;
        CIMObjectPath cIMObjectPath2 = null;
        CIMObjectPath cIMObjectPath3 = null;
        CIMClass cIMClass = null;
        Object var8_8 = null;
        CIMInstance cIMInstance = null;
        short s2 = -1;
        boolean bl = false;
        this.fastActivateLpars = new Hashtable();
        this.runningLpars = new Hashtable();
        Hashtable<Object, Vector> hashtable = new Hashtable<Object, Vector>();
        short s3 = 1;
        while (s3 <= this.numOfLpars) {
            boolean bl2 = false;
            vector = nVRAM.getLPARInfo(hscProviderSocket, s3);
            if (vector != null) {
                object3 = null;
                object3 = s3 > 9 ? "0" + s3 : "00" + s3;
                object3 = (String)object3 + "*" + this.cecName;
                hashtable.put(object3, vector);
                System.out.println("++++++++ lpar found: " + s3);
                object2 = (String)vector.elementAt(0);
                if (object2 == null) {
                    bl2 = true;
                } else if (((String)object2).equals("")) {
                    bl2 = true;
                }
            } else {
                bl2 = true;
                System.out.println("++++++++ lpar not found: " + s3);
            }
            if (bl2 && this.cecState == 1 && this.cecMode == 255) {
                object3 = HscProviderUtils.doCSPCommand("GET_LPAR_SLOT_DEFINITION_STATE", new String[]{Integer.toHexString(s3)}, hscProviderSocket);
                object2 = (Integer)((Hashtable)object3).get("DEFINITION_STATE");
                System.out.println("lpar definition state:" + object2);
                if (((Integer)object2).shortValue() != 4 && ((Integer)object2).shortValue() != 14 && this.cecState != 12) {
                    System.out.println("putting cec into recovery state...");
                    this.cecInst.setProperty("state", new CIMValue((Object)new UnsignedInt8(251)));
                    this.cecModified = true;
                }
            }
            s3 = (short)(s3 + 1);
        }
        cIMObjectPath2 = new CIMObjectPath("IBMHSC_CompSysPartition", "root/ibmhscV3_2");
        Vector vector2 = CimomWrapper.associators(this.cimHandle, cIMObjectPath2, this.cecObjPath, null, "GroupComponent", "PartComponent", true, true, null);
        vector = null;
        if (vector2 != null && !vector2.isEmpty()) {
            object3 = vector2.elements();
            while (object3.hasMoreElements()) {
                object2 = (CIMInstance)object3.nextElement();
                vector = object2.filterProperties(null, true, true);
                object = (String)vector.getProperty(CONSOLE_KEY_NAME).getValue().getValue();
                s = Short.parseShort(((String)object).substring(0, 3));
                cIMObjectPath = new CIMObjectPath(vector.getClassName(), vector.getKeyValuePairs());
                cIMObjectPath.setNameSpace("root/ibmhscV3_2");
                if (s == 0) {
                    System.out.println("++++++++ full system partition");
                    int n2 = -1;
                    if (this.cecMode == 255) {
                        n2 = 252;
                    } else if (this.cecState == 3) {
                        n2 = 252;
                    } else if (this.cecState == 1) {
                        n2 = 8;
                    }
                    if (!CimomWrapper.setProperty((CIMInstance)vector, "PartitionState", new UnsignedInt8((short)n2))) continue;
                    System.out.println("++++++PartitionState updated: " + n2);
                    CimomWrapper.setInstance(this.cimHandle, cIMObjectPath, (CIMInstance)vector);
                    this.eventQueue.add(4, (CIMInstance)vector, (CIMInstance)object2);
                    continue;
                }
                System.out.println("++++++++ existing partition: " + (String)object);
                Vector vector3 = (Vector)hashtable.get(object);
                if (vector3 == null) {
                    System.out.println("++++++++ no such partition in nvram: " + (String)object);
                    cIMObjectPath2 = new CIMObjectPath(vector.getClassName(), vector.getKeyValuePairs());
                    cIMObjectPath2.setNameSpace("root/ibmhscV3_2");
                    HscCimObjUtils.deletePartition(this.eventQueue, this.cimHandle, (CIMInstance)vector, cIMObjectPath2);
                    this.eventQueue.add(2, (CIMInstance)vector, null);
                    continue;
                }
                s2 = this.updatePartitionProperties(hscProviderSocket, n, s, (String)object, (CIMInstance)vector, cIMObjectPath, vector3, true);
                if (s2 == 8 || s2 == 5 || s2 == 9 || CecUpdater.isFastActivate(new Short(s), this.cecName, hscProviderSocket)) {
                    bl = true;
                    this.runningLpars.put(new Short(s), vector3);
                    System.out.println("++++++++ running partition: " + (String)object);
                }
                this.updateProfiles(hscProviderSocket, n, nVRAM, cIMObjectPath, s2);
                if (CecUpdater.isFastActivate(new Short(s), this.cecName, hscProviderSocket)) {
                    this.debugAddFastActivate(new Short(s));
                }
                hashtable.remove(object);
            }
        }
        object3 = hashtable.keys();
        while (object3.hasMoreElements()) {
            System.out.println("++++++++ creating new lpar instance");
            object2 = (String)object3.nextElement();
            System.out.println("++++++++ new lpar name: " + (String)object2);
            object = (Vector)hashtable.get(object2);
            s = Short.parseShort(((String)object2).substring(0, 3));
            cIMObjectPath = new CIMObjectPath("IBMHSC_Partition", "root/ibmhscV3_2");
            cIMClass = providerCIMOMHandle.getClass(cIMObjectPath, false);
            vector = cIMClass.newInstance();
            s2 = this.updatePartitionProperties(hscProviderSocket, n, s, (String)object2, (CIMInstance)vector, null, (Vector)object, false);
            if (s2 == 8 || s2 == 5 || s2 == 9 || CecUpdater.isFastActivate(new Short(s), this.cecName, hscProviderSocket)) {
                bl = true;
                this.runningLpars.put(new Short(s), object);
                System.out.println("++++++++ new running partition found: " + (String)object2);
            }
            if (CecUpdater.isFastActivate(new Short(s), this.cecName, hscProviderSocket)) {
                this.debugAddFastActivate(new Short(s));
            }
            CIMObjectPath cIMObjectPath4 = new CIMObjectPath(vector.getClassName(), vector.getKeyValuePairs());
            cIMObjectPath4.setNameSpace("root/ibmhscV3_2");
            CIMObjectPath cIMObjectPath5 = CimomWrapper.createInstance(this.cimHandle, cIMObjectPath4, (CIMInstance)vector);
            this.eventQueue.add(1, (CIMInstance)vector, null);
            this.updateProfiles(hscProviderSocket, n, nVRAM, cIMObjectPath5, s2);
            cIMObjectPath2 = new CIMObjectPath("IBMHSC_CompSysPartition", "root/ibmhscV3_2");
            cIMClass = providerCIMOMHandle.getClass(cIMObjectPath2, false);
            cIMInstance = cIMClass.newInstance();
            cIMInstance.setProperty("GroupComponent", new CIMValue((Object)this.cecObjPath));
            cIMInstance.setProperty("PartComponent", new CIMValue((Object)cIMObjectPath5));
            cIMObjectPath3 = new CIMObjectPath(cIMInstance.getClassName(), cIMInstance.getKeyValuePairs());
            cIMObjectPath3.setNameSpace("root/ibmhscV3_2");
            CimomWrapper.createInstance(this.cimHandle, cIMObjectPath3, cIMInstance);
        }
        if (bl) {
            this.updateAllocatedSlots(this.runningLpars, hscProviderSocket);
            this.updateAllocatedProcessors(this.runningLpars, hscProviderSocket);
        }
        if ((float)n > 3000.0f) {
            this.smaUpdater.updateAllocatedSni(hscProviderSocket, this.runningLpars);
        }
    }

    private short updatePartitionProperties(HscProviderSocket hscProviderSocket, int n, short s, String string, CIMInstance cIMInstance, CIMObjectPath cIMObjectPath, Vector vector, boolean bl) throws CIMException {
        boolean bl2 = false;
        Integer n2 = null;
        Hashtable hashtable = null;
        String string2 = null;
        String string3 = null;
        UnsignedInt8 unsignedInt8 = new UnsignedInt8(1);
        UnsignedInt8 unsignedInt82 = new UnsignedInt8(1);
        String string4 = (String)vector.elementAt(0);
        int n3 = -1;
        String[] stringArray = new String[]{Integer.toHexString(s)};
        if ((float)n >= 2000.0f) {
            String string5 = (String)vector.elementAt(1);
            if (string5 != null) {
                string2 = string5.substring(0, string5.length() - 1);
                string3 = string5.substring(string5.length() - 1);
            }
            unsignedInt8 = new UnsignedInt8(((Short)vector.elementAt(2)).shortValue());
            short s2 = unsignedInt8.shortValue();
            if (this.cecState == 1 && this.cecMode == 255) {
                hashtable = HscProviderUtils.doCSPCommand("GET_LPAR_TYPE", stringArray, hscProviderSocket);
                n2 = (Integer)hashtable.get("TYPE_VALUE");
                short s3 = n2.shortValue();
                unsignedInt82 = new UnsignedInt8(((Integer)hashtable.get("RMO_TYPE")).shortValue());
                System.out.println("Runtime RMO type: " + unsignedInt82);
                if (s3 != s2) {
                    System.out.println("Putting CEC into Recovery state...");
                    this.cecInst.setProperty("State", new CIMValue((Object)new UnsignedInt8(251)));
                    CimomWrapper.setInstance(this.cimHandle, this.cecObjPath, this.cecInst);
                    try {
                        this.eventQueue.add(4, this.cecInst, this.oldCecInst);
                    }
                    catch (Throwable throwable) {
                        HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
                    }
                    throw new HSCCIMException("021C");
                }
            }
            if (string4.equalsIgnoreCase("")) {
                CIMObjectPath cIMObjectPath2 = new CIMObjectPath(cIMInstance.getClassName(), cIMInstance.getKeyValuePairs());
                cIMObjectPath2.setNameSpace("root/ibmhscV3_2");
                HscCimObjUtils.deletePartition(this.eventQueue, this.cimHandle, cIMInstance, cIMObjectPath2);
                this.eventQueue.add(2, cIMInstance, null);
                return (short)n3;
            }
            if (CimomWrapper.setPropertyString(cIMInstance, CONSOLE_KEY_NAME, string)) {
                System.out.println("++++++partition name updated: " + string);
                bl2 = true;
            }
            if (CimomWrapper.setPropertyString(cIMInstance, "CreationClassName", "IBMHSC_Partition")) {
                System.out.println("++++++CreationClassName updated: IBMHSC_Partition");
                bl2 = true;
            }
            if (CimomWrapper.setPropertyString(cIMInstance, "UserDefinedName", string4)) {
                System.out.println("++++++UserDefinedName updated: " + string4);
                bl2 = true;
            }
            if (CimomWrapper.setPropertyString(cIMInstance, "PhysLocCode", string2)) {
                System.out.println("++++++PhysLocCode updated: " + string2);
                bl2 = true;
            }
            if (CimomWrapper.setPropertyString(cIMInstance, "AffinityGroupID", string3)) {
                System.out.println("++++++AffinityGroupID updated: " + string3);
                bl2 = true;
            }
            if (CimomWrapper.setProperty(cIMInstance, "PartitionType", unsignedInt8)) {
                System.out.println("++++++PartitionType updated: " + unsignedInt8);
                bl2 = true;
            }
            if (CimomWrapper.setProperty(cIMInstance, "RuntimeRMOSize", unsignedInt82)) {
                System.out.println("++++++RuntimeRMOSize updated: " + unsignedInt82);
                bl2 = true;
            }
            if (this.cecState == 1 && this.cecMode == 255) {
                hashtable = HscProviderUtils.doCSPCommand("GET_LPAR_STATE", stringArray, hscProviderSocket);
                n2 = (Integer)hashtable.get("LPAR_STATE");
                n3 = n2.shortValue();
                if (vector.size() > 1 && (n3 == 1 || n3 == 12)) {
                    hashtable = HscProviderUtils.doCSPCommand("GET_PARTITION_MODE", null, hscProviderSocket);
                    n2 = (Integer)hashtable.get("MODE");
                    short s4 = n2.shortValue();
                    System.out.println("Partition mode: " + s4);
                    if (s4 == 1 && s2 != 1) {
                        n3 = 252;
                        System.out.println("PARTITION NOT AVAILABLE!!");
                        System.out.println("LPAR STATE: " + n3);
                    }
                    if (s4 == 3 && s2 != 3) {
                        n3 = 252;
                        System.out.println("PARTITION NOT AVAILABLE!!");
                        System.out.println("LPAR STATE: " + n3);
                    }
                    if (s4 == 2 && s2 != 2) {
                        n3 = 252;
                        System.out.println("PARTITION NOT AVAILABLE!!");
                        System.out.println("LPAR STATE: " + n3);
                    }
                }
                if ((n2 = (Integer)(hashtable = HscProviderUtils.doCSPCommand("GET_LPAR_SLOT_DEFINITION_STATE", stringArray, hscProviderSocket)).get("DEFINITION_STATE")).shortValue() == 4 && this.cecState != 12) {
                    if (CimomWrapper.setProperty(cIMInstance, "PartitionState", new UnsignedInt8(251))) {
                        System.out.println("++++++PartitionState updated: recovery");
                        bl2 = true;
                    }
                    System.out.println("Putting CEC into Recovery state... undefined lpar slot definition state");
                    this.cecInst.setProperty("state", new CIMValue((Object)new UnsignedInt8(251)));
                    throw new HSCCIMException("021D");
                }
            } else {
                n3 = 252;
            }
            if (CimomWrapper.setProperty(cIMInstance, "PartitionState", new UnsignedInt8((short)n3))) {
                System.out.println("++++++PartitionState updated: " + n3);
                bl2 = true;
            }
            if (this.cecState == 1 && this.cecMode == 255) {
                hashtable = HscProviderUtils.doCSPCommand("GET_LPAR_BOOT_ERROR_VALUES", stringArray, hscProviderSocket);
                n2 = (Integer)hashtable.get("BOOT_ERROR");
                if (CimomWrapper.setProperty(cIMInstance, "BootErrorValue", new UnsignedInt8(n2.shortValue()))) {
                    System.out.println("++++++BootErrorValue updated: " + n2);
                    bl2 = true;
                }
                if (CimomWrapper.setPropertyCIMValue(cIMInstance, "Editable", CIMValue.TRUE)) {
                    System.out.println("++++++Editable updated: " + CIMValue.TRUE);
                    bl2 = true;
                }
                if (this.rebuildFlag == 0) {
                    ComputerSystemProvUtils.closeVTTYTerminal(hscProviderSocket, stringArray, s);
                }
            }
        }
        if (bl2 && bl && cIMObjectPath != null) {
            System.out.println("++++++ partition modified");
            CimomWrapper.setInstance(this.cimHandle, cIMObjectPath, cIMInstance);
            this.eventQueue.add(4, cIMInstance, cIMInstance);
        }
        return (short)n3;
    }

    private void updateProfiles(HscProviderSocket hscProviderSocket, int n, NVRAM nVRAM, CIMObjectPath cIMObjectPath, short s) throws CIMException {
        CIMObjectPath cIMObjectPath2;
        Object object;
        String string;
        Object object2;
        Object object3;
        Object object4;
        CIMProperty cIMProperty;
        Vector vector;
        CIMObjectPath cIMObjectPath3;
        Object object5;
        boolean bl = false;
        Vector vector2 = cIMObjectPath.getKeys();
        String string2 = null;
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            object5 = (CIMProperty)enumeration.nextElement();
            if (!object5.getName().equalsIgnoreCase(CONSOLE_KEY_NAME)) continue;
            string2 = (String)object5.getValue().getValue();
            break;
        }
        object5 = string2.substring(string2.indexOf(42) + 1);
        short s2 = Short.parseShort(string2.substring(0, 3));
        Vector vector3 = new Vector();
        vector3 = nVRAM.getLPARProfilesAtPartition(s2, hscProviderSocket);
        System.out.println(" get profiles for partition " + s2 + ": " + vector3);
        String string3 = "";
        String string4 = "";
        String string5 = "";
        Hashtable<String, Vector> hashtable = new Hashtable<String, Vector>();
        if (vector3.isEmpty()) {
            System.out.println("+++++++ no profiles found in the nvram for partition " + s2);
        } else {
            cIMObjectPath3 = vector3.elements();
            while (cIMObjectPath3.hasMoreElements()) {
                vector = (Vector)cIMObjectPath3.nextElement();
                cIMProperty = (CIMProperty)vector.elementAt(0);
                string3 = (String)cIMProperty.getValue().getValue();
                hashtable.put(string3, vector);
                if (this.isDefaultLparProfile(n, vector)) {
                    if (string4.equals("")) {
                        string4 = string3;
                        System.out.println("+++++++ default profile: " + string3);
                    } else {
                        System.out.println("+++++++ ERROR: duplicate default profiles");
                    }
                }
                if (!this.isProfileActivated(n, vector)) continue;
                if (string5.equals("")) {
                    string5 = string3;
                    System.out.println("+++++++ activated profile: " + string3);
                    continue;
                }
                System.out.println("+++++++ ERROR: duplicate activated profiles");
            }
        }
        if (string4.equals("")) {
            System.out.println("+++++++ ERROR: no default profile defined in nvram for the partition");
        }
        cIMObjectPath3 = new CIMObjectPath("IBMHSC_PartitionProfile", "root/ibmhscV3_2");
        vector = null;
        try {
            vector = CimomWrapper.associators(this.cimHandle, cIMObjectPath3, cIMObjectPath, null, "Element", "Setting", true, true, null);
        }
        catch (Throwable throwable) {
            System.out.println("++++++ERROR: no profile defined in cimom for partition " + s2);
            throwable.printStackTrace();
            vector = null;
        }
        cIMProperty = null;
        CIMObjectPath cIMObjectPath4 = null;
        if (vector != null && !vector.isEmpty()) {
            object4 = vector.elements();
            while (object4.hasMoreElements()) {
                object3 = (CIMInstance)object4.nextElement();
                object2 = object3.filterProperties(null, true, true);
                string = (String)object2.getProperty("SettingID").getValue().getValue();
                System.out.println("+++++++++++++existing profile: " + string);
                object = (Vector)hashtable.get(string);
                cIMObjectPath2 = new CIMObjectPath(object2.getClassName(), object2.getKeyValuePairs());
                cIMObjectPath2.setNameSpace("root/ibmhscV3_2");
                if (string.equalsIgnoreCase(string4)) {
                    cIMProperty = cIMObjectPath2;
                }
                if (string.equalsIgnoreCase(string5)) {
                    cIMObjectPath4 = cIMObjectPath2;
                }
                if (object == null) {
                    System.out.println("+++++++++++++profile no longer existing: " + string);
                    HscCimObjUtils.deleteProfile(this.eventQueue, this.cimHandle, (CIMInstance)object2, cIMObjectPath2, cIMObjectPath);
                    this.eventQueue.add(2, (CIMInstance)object2, null);
                    continue;
                }
                if (this.updateLparProfileProperties(n, string2, (Vector)object, (CIMInstance)object2, cIMObjectPath2)) {
                    bl = true;
                    this.eventQueue.add(4, (CIMInstance)object2, (CIMInstance)object3);
                }
                Vector vector4 = (Vector)hashtable.remove(string);
                vector3.remove(vector4);
            }
        }
        if (vector3.size() != 0) {
            System.out.println("+++++++++++++ adding " + vector3.size() + " new profiles.");
            this.addNewLparProfile(this.cimHandle, cIMObjectPath, vector3, hscProviderSocket);
        }
        cIMObjectPath3 = new CIMObjectPath("IBMHSC_DefaultLparProfile", "root/ibmhscV3_2");
        object4 = null;
        try {
            object4 = CimomWrapper.associators(this.cimHandle, cIMObjectPath3, cIMObjectPath, null, "Element", "Setting", true, true, null);
        }
        catch (Throwable throwable) {
            System.out.println("++++++ERROR: no default profile defined in cimom for partition " + s2);
            throwable.printStackTrace();
            object4 = null;
        }
        if (object4 != null && ((Vector)object4).size() == 1) {
            object3 = ((Vector)object4).elements();
            object2 = (CIMInstance)object3.nextElement();
            string = (String)object2.getProperty("SettingID").getValue().getValue();
            System.out.println("+++++++++ default profile: " + string);
            if (!string.equalsIgnoreCase(string4) && cIMProperty != null) {
                System.out.println("+++++++ Deleting old default profile association ++++++++");
                cIMObjectPath3 = new CIMObjectPath(object2.getClassName(), object2.getKeyValuePairs());
                cIMObjectPath3.setNameSpace("root/ibmhscV3_2");
                CimomWrapper.deleteInstance(this.cimHandle, cIMObjectPath3);
                cIMObjectPath3 = new CIMObjectPath("IBMHSC_DefaultLparProfile", "root/ibmhscV3_2");
                object = this.cimHandle.getClass(cIMObjectPath3, false).newInstance();
                object.setProperty("Element", new CIMValue((Object)cIMObjectPath));
                object.setProperty("Setting", new CIMValue((Object)cIMProperty));
                cIMObjectPath3 = new CIMObjectPath(object.getClassName(), object.getKeyValuePairs());
                cIMObjectPath3.setNameSpace("root/ibmhscV3_2");
                CimomWrapper.createInstance(this.cimHandle, cIMObjectPath3, (CIMInstance)object);
                System.out.println("+++++++++ default profile has been changed to: " + string4);
            }
        } else if (object4 == null || ((Vector)object4).size() == 0) {
            System.out.println("there was no default profile in cimom for partition " + s2);
            if (!string4.equals("") && cIMProperty != null) {
                cIMObjectPath3 = new CIMObjectPath("IBMHSC_DefaultLparProfile", "root/ibmhscV3_2");
                object3 = this.cimHandle.getClass(cIMObjectPath3, false).newInstance();
                object3.setProperty("Element", new CIMValue((Object)cIMObjectPath));
                object3.setProperty("Setting", new CIMValue((Object)cIMProperty));
                cIMObjectPath3 = new CIMObjectPath(object3.getClassName(), object3.getKeyValuePairs());
                cIMObjectPath3.setNameSpace("root/ibmhscV3_2");
                CimomWrapper.createInstance(this.cimHandle, cIMObjectPath3, (CIMInstance)object3);
                System.out.println("+++++++++ default profile created: " + string4);
            }
        } else {
            System.out.println("bug: there were more than one default profiles in cimom for partition " + s2);
        }
        cIMObjectPath3 = new CIMObjectPath("IBMHSC_ActivatedLparProfile", "root/ibmhscV3_2");
        object3 = null;
        try {
            object3 = CimomWrapper.associators(this.cimHandle, cIMObjectPath3, cIMObjectPath, null, "Element", "Setting", true, true, null);
        }
        catch (Throwable throwable) {
            System.out.println("++++++ no activated profile defined in cimom for partition " + s2);
            throwable.printStackTrace();
            object3 = null;
        }
        if (object3 != null && ((Vector)object3).size() == 1) {
            object2 = ((Vector)object3).elements();
            string = (CIMInstance)object2.nextElement();
            object = (String)string.getProperty("SettingID").getValue().getValue();
            System.out.println("+++++++++ activated lpar profile: " + (String)object);
            if (!((String)object).equalsIgnoreCase(string5) && cIMObjectPath4 != null) {
                cIMObjectPath3 = new CIMObjectPath(string.getClassName(), string.getKeyValuePairs());
                cIMObjectPath3.setNameSpace("root/ibmhscV3_2");
                CimomWrapper.deleteInstance(this.cimHandle, cIMObjectPath3);
                System.out.println("+++++++++ profile: " + (String)object + " is no longer activated.");
                cIMObjectPath3 = new CIMObjectPath("IBMHSC_ActivatedLparProfile", "root/ibmhscV3_2");
                cIMObjectPath2 = this.cimHandle.getClass(cIMObjectPath3, false).newInstance();
                cIMObjectPath2.setProperty("Element", new CIMValue((Object)cIMObjectPath));
                cIMObjectPath2.setProperty("Setting", new CIMValue((Object)cIMObjectPath4));
                cIMObjectPath3 = new CIMObjectPath(cIMObjectPath2.getClassName(), cIMObjectPath2.getKeyValuePairs());
                cIMObjectPath3.setNameSpace("root/ibmhscV3_2");
                CimomWrapper.createInstance(this.cimHandle, cIMObjectPath3, (CIMInstance)cIMObjectPath2);
                System.out.println("+++++++++ profile: " + (String)object + " is now activated.");
            }
        } else if (cIMObjectPath4 != null) {
            cIMObjectPath3 = new CIMObjectPath("IBMHSC_ActivatedLparProfile", "root/ibmhscV3_2");
            object2 = this.cimHandle.getClass(cIMObjectPath3, false).newInstance();
            object2.setProperty("Element", new CIMValue((Object)cIMObjectPath));
            object2.setProperty("Setting", new CIMValue((Object)cIMObjectPath4));
            cIMObjectPath3 = new CIMObjectPath(object2.getClassName(), object2.getKeyValuePairs());
            cIMObjectPath3.setNameSpace("root/ibmhscV3_2");
            CimomWrapper.createInstance(this.cimHandle, cIMObjectPath3, (CIMInstance)object2);
            System.out.println("+++++++++ activatedlparprofile: " + cIMObjectPath4);
        }
    }

    private boolean updateLparProfileProperties(int n, String string, Vector vector, CIMInstance cIMInstance, CIMObjectPath cIMObjectPath) throws CIMException {
        Vector vector2;
        Vector vector3;
        Vector vector4;
        UnsignedInt32 unsignedInt32;
        UnsignedInt32 unsignedInt322;
        UnsignedInt8 unsignedInt8;
        UnsignedInt8 unsignedInt82;
        UnsignedInt8 unsignedInt83;
        UnsignedInt8 unsignedInt84;
        String string2;
        UnsignedInt8 unsignedInt85 = null;
        UnsignedInt32 unsignedInt323 = null;
        UnsignedInt8 unsignedInt86 = null;
        Vector vector5 = null;
        Vector vector6 = null;
        boolean bl = false;
        System.out.println("+++++++++++++ updateLparProfileProperties");
        if ((float)n >= 3000.0f) {
            CIMProperty cIMProperty = (CIMProperty)vector.elementAt(1);
            string2 = (String)cIMProperty.getValue().getValue();
            cIMProperty = (CIMProperty)vector.elementAt(2);
            unsignedInt84 = (UnsignedInt8)cIMProperty.getValue().getValue();
            cIMProperty = (CIMProperty)vector.elementAt(3);
            unsignedInt83 = (UnsignedInt8)cIMProperty.getValue().getValue();
            cIMProperty = (CIMProperty)vector.elementAt(4);
            UnsignedInt8 unsignedInt87 = (UnsignedInt8)cIMProperty.getValue().getValue();
            cIMProperty = (CIMProperty)vector.elementAt(5);
            UnsignedInt8 unsignedInt88 = (UnsignedInt8)cIMProperty.getValue().getValue();
            cIMProperty = (CIMProperty)vector.elementAt(6);
            unsignedInt82 = (UnsignedInt8)cIMProperty.getValue().getValue();
            cIMProperty = (CIMProperty)vector.elementAt(7);
            unsignedInt8 = (UnsignedInt8)cIMProperty.getValue().getValue();
            cIMProperty = (CIMProperty)vector.elementAt(8);
            unsignedInt85 = (UnsignedInt8)cIMProperty.getValue().getValue();
            cIMProperty = (CIMProperty)vector.elementAt(9);
            unsignedInt322 = (UnsignedInt32)cIMProperty.getValue().getValue();
            cIMProperty = (CIMProperty)vector.elementAt(10);
            unsignedInt32 = (UnsignedInt32)cIMProperty.getValue().getValue();
            cIMProperty = (CIMProperty)vector.elementAt(11);
            unsignedInt323 = (UnsignedInt32)cIMProperty.getValue().getValue();
            cIMProperty = (CIMProperty)vector.elementAt(12);
            vector4 = (Vector)cIMProperty.getValue().getValue();
            if (vector4 == null) {
                vector4 = new Vector();
            }
            if ((vector3 = (Vector)(cIMProperty = (CIMProperty)vector.elementAt(13)).getValue().getValue()) == null) {
                vector3 = new Vector();
            }
            cIMProperty = (CIMProperty)vector.elementAt(14);
            vector2 = (Vector)cIMProperty.getValue().getValue();
            if ((float)n > 3000.0f) {
                cIMProperty = (CIMProperty)vector.elementAt(15);
                unsignedInt86 = (UnsignedInt8)cIMProperty.getValue().getValue();
                cIMProperty = (CIMProperty)vector.elementAt(16);
                vector5 = (Vector)cIMProperty.getValue().getValue();
                if (vector5 == null) {
                    vector5 = new Vector();
                }
                if ((vector6 = (Vector)(cIMProperty = (CIMProperty)vector.elementAt(17)).getValue().getValue()) == null) {
                    vector6 = new Vector();
                }
            }
        } else {
            CIMProperty cIMProperty = (CIMProperty)vector.elementAt(1);
            string2 = (String)cIMProperty.getValue().getValue();
            cIMProperty = (CIMProperty)vector.elementAt(2);
            unsignedInt84 = (UnsignedInt8)cIMProperty.getValue().getValue();
            cIMProperty = (CIMProperty)vector.elementAt(3);
            unsignedInt83 = (UnsignedInt8)cIMProperty.getValue().getValue();
            cIMProperty = (CIMProperty)vector.elementAt(4);
            unsignedInt82 = (UnsignedInt8)cIMProperty.getValue().getValue();
            cIMProperty = (CIMProperty)vector.elementAt(5);
            unsignedInt8 = (UnsignedInt8)cIMProperty.getValue().getValue();
            cIMProperty = (CIMProperty)vector.elementAt(6);
            unsignedInt322 = (UnsignedInt32)cIMProperty.getValue().getValue();
            cIMProperty = (CIMProperty)vector.elementAt(7);
            unsignedInt32 = (UnsignedInt32)cIMProperty.getValue().getValue();
            cIMProperty = (CIMProperty)vector.elementAt(8);
            vector4 = (Vector)cIMProperty.getValue().getValue();
            if (vector4 == null) {
                vector4 = new Vector();
            }
            if ((vector3 = (Vector)(cIMProperty = (CIMProperty)vector.elementAt(9)).getValue().getValue()) == null) {
                vector3 = new Vector();
            }
            if ((vector2 = (Vector)(cIMProperty = (CIMProperty)vector.elementAt(10)).getValue().getValue()) == null) {
                vector2 = new Vector();
            }
        }
        if (CimomWrapper.setPropertyString(cIMInstance, "PartitionName", string)) {
            bl = true;
        }
        if (CimomWrapper.setPropertyString(cIMInstance, "UserDefinedName", string2)) {
            bl = true;
        }
        if (CimomWrapper.setPropertyString(cIMInstance, "PartitionCreationClassName", "IBMHSC_Partition")) {
            bl = true;
        }
        if (CimomWrapper.setProperty(cIMInstance, "BootMode", unsignedInt84)) {
            bl = true;
        }
        if (CimomWrapper.setProperty(cIMInstance, "ServiceAuthority", unsignedInt83)) {
            bl = true;
        }
        if (CimomWrapper.setProperty(cIMInstance, "DesiredMemoryMB", unsignedInt322)) {
            bl = true;
        }
        if (CimomWrapper.setProperty(cIMInstance, "MinimumMemoryMB", unsignedInt32)) {
            bl = true;
        }
        if ((float)n >= 3000.0f) {
            if (CimomWrapper.setProperty(cIMInstance, "MaximumMemoryMB", unsignedInt323)) {
                bl = true;
            }
            if (CimomWrapper.setProperty(cIMInstance, "MaximumCPUCount", unsignedInt85)) {
                bl = true;
            }
        }
        if (CimomWrapper.setProperty(cIMInstance, "DesiredCPUCount", unsignedInt82)) {
            bl = true;
        }
        if (CimomWrapper.setProperty(cIMInstance, "MinimumCPUCount", unsignedInt8)) {
            bl = true;
        }
        if (CimomWrapper.setProperty(cIMInstance, "IOSlots", vector3, new CIMDataType(21))) {
            bl = true;
        }
        if (CimomWrapper.setProperty(cIMInstance, "IODrawer", vector4, new CIMDataType(29))) {
            bl = true;
        }
        if (CimomWrapper.setProperty(cIMInstance, "IORequirement", vector2, new CIMDataType(29))) {
            bl = true;
        }
        if ((float)n > 3000.0f) {
            if (CimomWrapper.setProperty(cIMInstance, "SNIConfigMode", unsignedInt86)) {
                bl = true;
            }
            if (CimomWrapper.setProperty(cIMInstance, "SNIDeviceID", vector5, new CIMDataType(29))) {
                bl = true;
            }
            if (CimomWrapper.setProperty(cIMInstance, "SNIWindows", vector6, new CIMDataType(23))) {
                bl = true;
            }
        }
        if (bl) {
            CimomWrapper.setInstance(this.cimHandle, cIMObjectPath, cIMInstance);
        }
        System.out.println("+++++++++ updateLparProfileProperties ++++ modified = " + bl);
        return bl;
    }

    private boolean isDefaultLparProfile(int n, Vector vector) {
        CIMProperty cIMProperty = (float)n >= 3000.0f ? ((float)n > 3000.0f ? (CIMProperty)vector.elementAt(18) : (CIMProperty)vector.elementAt(15)) : (CIMProperty)vector.elementAt(11);
        Boolean bl = (Boolean)cIMProperty.getValue().getValue();
        return bl;
    }

    private boolean isProfileActivated(int n, Vector vector) {
        CIMProperty cIMProperty = (float)n >= 3000.0f ? ((float)n > 3000.0f ? (CIMProperty)vector.elementAt(19) : (CIMProperty)vector.elementAt(16)) : (CIMProperty)vector.elementAt(12);
        Boolean bl = (Boolean)cIMProperty.getValue().getValue();
        return bl;
    }

    private void updateAllocatedSlots(Hashtable hashtable, HscProviderSocket hscProviderSocket) throws CIMException {
        String string;
        CIMInstance cIMInstance;
        Vector vector;
        String string2;
        short s;
        Object object;
        Object object2;
        String[] stringArray;
        Hashtable hashtable2 = null;
        Hashtable<String, Short> hashtable3 = new Hashtable<String, Short>();
        System.out.println("+++++++++ updateAllocatedSlots begins");
        hashtable2 = HscProviderUtils.doCSPCommand("GET_NUM_IO_DRAWERS", null, hscProviderSocket);
        Integer n = (Integer)hashtable2.get("NUM_IO_DRAWERS");
        int n2 = n.shortValue();
        System.out.println("+++++++++ num of io drawers: " + n2);
        String[] stringArray2 = (String[])hashtable2.get("DRAWER_IDS");
        int n3 = 0;
        while (n3 < n2) {
            System.out.println("+++++++++ check drawer: " + n3);
            stringArray = new String[]{stringArray2[n3]};
            System.out.println("+++++++++ drawer id: " + stringArray[0]);
            hashtable2 = HscProviderUtils.doCSPCommand("GET_IO_DRAWER_INFO", stringArray, hscProviderSocket);
            n = (Integer)hashtable2.get("NUM_SLOTS");
            int n4 = n.shortValue();
            System.out.println("+++++++++ num of slots: " + n4);
            object2 = (Hashtable)hashtable2.get("SLOT_INFORMATION");
            int n5 = 0;
            while (n5 < n4) {
                System.out.println("+++++++++ check slot: " + n5);
                object = (Hashtable)((Hashtable)object2).get(new Integer(n5));
                n = (Integer)((Hashtable)object).get("SLOT_NO");
                short s2 = n.shortValue();
                System.out.println("+++++++++ slot id: " + s2);
                n = (Integer)((Hashtable)object).get("LPAR_ID");
                s = n.shortValue();
                System.out.println("+++++++++ slot lpar id: " + s);
                Object v = hashtable.get(new Short(s));
                if (v == null) {
                    System.out.println("+++++++++ the lpar is  !running || !fastActivate || !exist");
                } else if (s >= 1 && s <= this.numOfLpars) {
                    string2 = new CIMObjectPath("IBMHSC_PCISlot", "root/ibmhscV3_2");
                    string2.addKey("IODrawerDeviceID", new CIMValue((Object)stringArray[0]));
                    string2.addKey("SlotID", new CIMValue((Object)new UnsignedInt8(s2)));
                    string2.addKey("IODrawerCreationClassName", new CIMValue((Object)"IBMHSC_IODrawer"));
                    string2.addKey("IODrawerSystemName", new CIMValue((Object)this.cecName));
                    string2.addKey("IODrawerSystemCreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
                    System.out.println("+++++++++ assigned partition id: " + s);
                    hashtable3.put(string2, new Short(s));
                } else {
                    System.out.println("+++++++++ drawer " + n3 + " slot " + n5 + " not assigned");
                }
                ++n5;
            }
            ++n3;
        }
        stringArray = new CIMObjectPath("IBMHSC_CompSysPartition", "root/ibmhscV3_2");
        Vector vector2 = CimomWrapper.associators(this.cimHandle, (CIMObjectPath)stringArray, this.cecObjPath, null, "GroupComponent", "PartComponent", true, true, null);
        object2 = null;
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            object2 = (CIMInstance)enumeration.nextElement();
            object = new CIMObjectPath(object2.getClassName(), object2.getKeyValuePairs());
            object.setNameSpace("root/ibmhscV3_2");
            String string3 = (String)object2.getProperty(CONSOLE_KEY_NAME).getValue().getValue();
            s = Short.parseShort(string3.substring(0, 3));
            if (s == 0) continue;
            short s3 = ((UnsignedInt8)object2.getProperty("PartitionState").getValue().getValue()).shortValue();
            boolean bl = false;
            if (s3 == 8 || s3 == 5 || s3 == 9) {
                System.out.println("++++++++ Partition " + s + " is running. ");
                bl = true;
            }
            boolean bl2 = false;
            if (s3 == 1 && CecUpdater.isFastActivate(new Short(s), this.cecName, hscProviderSocket)) {
                bl2 = true;
            }
            if ((vector = CimomWrapper.associators(this.cimHandle, (CIMObjectPath)(stringArray = new CIMObjectPath("IBMHSC_AllocatedSlot", "root/ibmhscV3_2")), (CIMObjectPath)object, null, "GroupComponent", "PartComponent", true, true, null)) != null && !vector.isEmpty()) {
                Enumeration enumeration2 = vector.elements();
                block3: while (enumeration2.hasMoreElements()) {
                    cIMInstance = (CIMInstance)enumeration2.nextElement();
                    string = (String)cIMInstance.getProperty("IODrawerDeviceID").getValue().getValue();
                    short s4 = ((UnsignedInt8)cIMInstance.getProperty("SlotID").getValue().getValue()).shortValue();
                    System.out.println("+++++++++ existing allocated slot: drawer=" + string + " slot=" + s4);
                    CIMObjectPath cIMObjectPath = new CIMObjectPath("IBMHSC_PCISlot", "root/ibmhscV3_2");
                    cIMObjectPath.addKey("IODrawerDeviceID", new CIMValue((Object)string));
                    cIMObjectPath.addKey("SlotID", new CIMValue((Object)new UnsignedInt8(s4)));
                    cIMObjectPath.addKey("IODrawerCreationClassName", new CIMValue((Object)"IBMHSC_IODrawer"));
                    cIMObjectPath.addKey("IODrawerSystemName", new CIMValue((Object)this.cecName));
                    cIMObjectPath.addKey("IODrawerSystemCreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
                    Short s5 = (Short)hashtable3.get(cIMObjectPath);
                    System.out.println("lparIdShort in updateAllocatedSlots is >>>>>>>>>>>> " + s5 + " for drawer id " + string + " and slotId " + s4);
                    if (s5 == null || s != s5 || !bl && !bl2) {
                        System.out.println("+++++++++ drawer " + string + " slot " + s4 + " no longer assigned to " + s);
                        stringArray = new CIMObjectPath("IBMHSC_AllocatedSlot", "root/ibmhscV3_2");
                        Enumeration enumeration3 = CimomWrapper.referenceNames(this.cimHandle, (CIMObjectPath)stringArray, (CIMObjectPath)object, null).elements();
                        while (enumeration3.hasMoreElements()) {
                            CIMObjectPath cIMObjectPath2 = (CIMObjectPath)enumeration3.nextElement();
                            System.out.println("+++++++++ check association: " + cIMObjectPath2);
                            CIMInstance cIMInstance2 = CimomWrapper.getInstance(this.cimHandle, cIMObjectPath2, new CIMClass("IBMHSC_AllocatedSlot"), false);
                            stringArray = (CIMObjectPath)cIMInstance2.getProperty("PartComponent").getValue().getValue();
                            CIMInstance cIMInstance3 = CimomWrapper.getInstance(this.cimHandle, (CIMObjectPath)stringArray, new CIMClass("IBMHSC_PCISlot"), false);
                            String string4 = (String)cIMInstance3.getProperty("IODrawerDeviceID").getValue().getValue();
                            short s6 = ((UnsignedInt8)cIMInstance3.getProperty("SlotID").getValue().getValue()).shortValue();
                            if (!string.equalsIgnoreCase(string4) || s4 != s6) continue;
                            System.out.println("+++++++++ delete association: " + cIMObjectPath2);
                            CimomWrapper.deleteInstance(this.cimHandle, cIMObjectPath2);
                            continue block3;
                        }
                        continue;
                    }
                    hashtable3.remove(cIMObjectPath);
                }
                continue;
            }
            System.out.println("+++++++++ no allocated slot for partition " + s);
        }
        object = hashtable3.keys();
        while (object.hasMoreElements()) {
            CIMObjectPath cIMObjectPath = (CIMObjectPath)object.nextElement();
            System.out.println("+++++++++ newly allocated slot: " + cIMObjectPath);
            Short s7 = (Short)hashtable3.get(cIMObjectPath);
            short s8 = s7;
            string2 = null;
            string2 = s8 > 9 ? "0" + s8 : "00" + s8;
            string2 = string2 + "*" + this.cecName;
            CIMObjectPath cIMObjectPath3 = new CIMObjectPath("IBMHSC_Partition", "root/ibmhscV3_2");
            cIMObjectPath3.addKey(CONSOLE_KEY_NAME, new CIMValue((Object)string2));
            cIMObjectPath3.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_Partition"));
            vector = CimomWrapper.getInstance(this.cimHandle, cIMObjectPath3, new CIMClass("IBMHSC_Partition"), false);
            short s9 = ((UnsignedInt8)vector.getProperty("PartitionState").getValue().getValue()).shortValue();
            if (s9 != 8 && s9 != 5 && s9 != 9 && s9 != 1 && !CecUpdater.isFastActivate(new Short(s8), this.cecName, hscProviderSocket)) continue;
            System.out.println("++++++++ Partition " + s8 + " is running..or is Fast.");
            cIMInstance = new CIMObjectPath("IBMHSC_AllocatedSlot", "root/ibmhscV3_2");
            string = this.cimHandle.getClass((CIMObjectPath)cIMInstance, false).newInstance();
            string.setProperty("GroupComponent", new CIMValue((Object)cIMObjectPath3));
            string.setProperty("PartComponent", new CIMValue((Object)cIMObjectPath));
            stringArray = new CIMObjectPath(string.getClassName(), string.getKeyValuePairs());
            stringArray.setNameSpace("root/ibmhscV3_2");
            CimomWrapper.createInstance(this.cimHandle, (CIMObjectPath)stringArray, (CIMInstance)string);
        }
        System.out.println("+++++++++ end of updateAllocatedSlots");
    }

    private void updateAllocatedProcessors(Hashtable hashtable, HscProviderSocket hscProviderSocket) throws CIMException {
        CIMValue cIMValue;
        Number number;
        String[] stringArray;
        String string;
        short s;
        Object object;
        Short s2;
        CIMInstance cIMInstance;
        Object object2;
        Object object3;
        Integer n;
        Hashtable hashtable2 = null;
        Hashtable<Object, Short> hashtable3 = new Hashtable<Object, Short>();
        System.out.println("+++++++++ updateAllocatedProcessor begins");
        hashtable2 = HscProviderUtils.doCSPCommand("GET_ALL_PROC_LPAR_ASSIGN_VALUE", null, hscProviderSocket);
        Vector vector = (Vector)hashtable2.get("ALL_PROC_ASSIGNMENT");
        Enumeration enumeration = vector.elements();
        short s3 = 0;
        while (enumeration.hasMoreElements()) {
            n = (Integer)enumeration.nextElement();
            short s4 = n.shortValue();
            object3 = hashtable.get(new Short(s4));
            if (object3 == null) {
                System.out.println("+++++++++ the lpar is  !running || !fastActivate || !exist");
            } else if (s4 >= 1 && s4 <= this.numOfLpars) {
                object2 = new Short(s3);
                hashtable3.put(object2, new Short(s4));
                System.out.println("+++++++++ processor id: " + s3 + " assigned to partition " + s4);
            }
            s3 = (short)(s3 + 1);
        }
        n = new CIMObjectPath("IBMHSC_CompSysPartition", "root/ibmhscV3_2");
        Vector vector2 = CimomWrapper.associators(this.cimHandle, (CIMObjectPath)n, this.cecObjPath, null, "GroupComponent", "PartComponent", true, true, null);
        object3 = null;
        object2 = vector2.elements();
        while (object2.hasMoreElements()) {
            Vector vector3;
            cIMInstance = (CIMInstance)object2.nextElement();
            object3 = cIMInstance.filterProperties(null, true, true);
            s2 = new CIMObjectPath(object3.getClassName(), object3.getKeyValuePairs());
            s2.setNameSpace("root/ibmhscV3_2");
            object = (String)object3.getProperty(CONSOLE_KEY_NAME).getValue().getValue();
            s = Short.parseShort(((String)object).substring(0, 3));
            if (s == 0 || (string = hashtable.get(new Short(s))) == null) continue;
            stringArray = new String[]{Integer.toHexString(s)};
            hashtable2 = HscProviderUtils.doCSPCommand("GET_LPAR_MEMORY_RESOURCES", stringArray, hscProviderSocket, this.cspVersion);
            number = (Long)hashtable2.get("TOT_ALLOC_MEMORY");
            long l = (Long)number;
            number = (Long)hashtable2.get("PAGE_TABLE_ALLOC_MEMORY");
            long l2 = (Long)number;
            boolean bl = false;
            cIMValue = object3.getProperty("AllocatedMemory").getValue();
            if ((cIMValue != null && cIMValue.getValue() != null || l != 0L) && CimomWrapper.setProperty(object3, "AllocatedMemory", new UnsignedInt32(l))) {
                bl = true;
                System.out.println("+++++++++ AllocatedMemory changed to:" + l);
            }
            if (((cIMValue = object3.getProperty("PageTableMemory").getValue()) != null && cIMValue.getValue() != null || l2 != 0L) && CimomWrapper.setProperty(object3, "PageTableMemory", new UnsignedInt32(l2))) {
                bl = true;
                System.out.println("+++++++++ PageTableMemory changed to:" + l2);
            }
            if (bl) {
                CimomWrapper.setInstance(this.cimHandle, (CIMObjectPath)s2, object3);
                System.out.println("++++++++ allocated memory has been changed");
                this.eventQueue.add(4, (CIMInstance)object3, cIMInstance);
            }
            short s5 = ((UnsignedInt8)object3.getProperty("PartitionState").getValue().getValue()).shortValue();
            boolean bl2 = false;
            if (s5 == 8 || s5 == 5 || s5 == 9) {
                bl2 = true;
            }
            boolean bl3 = false;
            if (s5 == 1 && CecUpdater.isFastActivate(new Short(s), this.cecName, hscProviderSocket)) {
                bl3 = true;
            }
            if ((vector3 = CimomWrapper.associators(this.cimHandle, (CIMObjectPath)(n = new CIMObjectPath("IBMHSC_AllocatedProcessor", "root/ibmhscV3_2")), (CIMObjectPath)s2, null, "GroupComponent", "PartComponent", true, true, null)) != null && !vector3.isEmpty()) {
                Enumeration enumeration2 = vector3.elements();
                block2: while (enumeration2.hasMoreElements()) {
                    CIMInstance cIMInstance2 = (CIMInstance)enumeration2.nextElement();
                    short s6 = ((UnsignedInt8)cIMInstance2.getProperty("DeviceID").getValue().getValue()).shortValue();
                    System.out.println("+++++++++ existing allocated processor: " + s6);
                    Short s7 = (Short)hashtable3.get(new Short(s6));
                    if (s7 == null || s != s7 || !bl2 && !bl3) {
                        System.out.println("+++++++++ processor " + s6 + " no longer assigned to partition " + s);
                        n = new CIMObjectPath("IBMHSC_AllocatedProcessor", "root/ibmhscV3_2");
                        Enumeration enumeration3 = CimomWrapper.referenceNames(this.cimHandle, (CIMObjectPath)n, (CIMObjectPath)s2, null).elements();
                        while (enumeration3.hasMoreElements()) {
                            CIMObjectPath cIMObjectPath = (CIMObjectPath)enumeration3.nextElement();
                            System.out.println("+++++++++ check association: " + cIMObjectPath);
                            CIMInstance cIMInstance3 = CimomWrapper.getInstance(this.cimHandle, cIMObjectPath, new CIMClass("IBMHSC_AllocatedProcessor"), false);
                            n = (CIMObjectPath)cIMInstance3.getProperty("PartComponent").getValue().getValue();
                            CIMInstance cIMInstance4 = CimomWrapper.getInstance(this.cimHandle, (CIMObjectPath)n, new CIMClass("IBMHSC_Processor"), false);
                            short s8 = ((UnsignedInt8)cIMInstance4.getProperty("DeviceID").getValue().getValue()).shortValue();
                            if (s6 != s8) continue;
                            System.out.println("+++++++++ delete association: " + cIMObjectPath);
                            CimomWrapper.deleteInstance(this.cimHandle, cIMObjectPath);
                            continue block2;
                        }
                        continue;
                    }
                    hashtable3.remove(new Short(s6));
                }
                continue;
            }
            System.out.println("+++++++++ no allocated cpu for partition " + s);
        }
        cIMInstance = hashtable3.keys();
        while (cIMInstance.hasMoreElements()) {
            s2 = (Short)cIMInstance.nextElement();
            System.out.println("+++++++++ newly allocated cpu: " + s2);
            object = (Short)hashtable3.get(s2);
            s = (Short)object;
            string = null;
            string = s > 9 ? "0" + s : "00" + s;
            string = string + "*" + this.cecName;
            stringArray = new String[]{Integer.toHexString(s2.shortValue())};
            hashtable2 = HscProviderUtils.doCSPCommand("GET_PROC_STATUS", stringArray, hscProviderSocket);
            number = (Integer)hashtable2.get("PROC_STATUS");
            short s9 = ((Integer)number).shortValue();
            if (s9 == 0 || s9 == 16) {
                System.out.println("+++++++++ this processor is no good, don't create it as a resource");
                continue;
            }
            CIMObjectPath cIMObjectPath = new CIMObjectPath("IBMHSC_Partition", "root/ibmhscV3_2");
            cIMObjectPath.addKey(CONSOLE_KEY_NAME, new CIMValue((Object)string));
            cIMObjectPath.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_Partition"));
            CIMInstance cIMInstance5 = CimomWrapper.getInstance(this.cimHandle, cIMObjectPath, new CIMClass("IBMHSC_Partition"), false);
            short s10 = ((UnsignedInt8)cIMInstance5.getProperty("PartitionState").getValue().getValue()).shortValue();
            System.out.println("+++++++++ lpar state: " + s10);
            if (s10 != 8 && s10 != 5 && s10 != 9 && s10 != 1 && !CecUpdater.isFastActivate(new Short(s), this.cecName, hscProviderSocket)) {
                System.out.println("+++++++lpar not running. Do not create the allocated processor association");
                continue;
            }
            CIMObjectPath cIMObjectPath2 = new CIMObjectPath("IBMHSC_Processor", "root/ibmhscV3_2");
            cIMObjectPath2.addKey("DeviceID", new CIMValue((Object)new UnsignedInt8(s2.shortValue())));
            cIMObjectPath2.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_Processor"));
            cIMObjectPath2.addKey("SystemCreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
            cIMObjectPath2.addKey("SystemName", new CIMValue((Object)this.cecName));
            n = new CIMObjectPath("IBMHSC_AllocatedProcessor", "root/ibmhscV3_2");
            cIMValue = this.cimHandle.getClass((CIMObjectPath)n, false).newInstance();
            cIMValue.setProperty("GroupComponent", new CIMValue((Object)cIMObjectPath));
            cIMValue.setProperty("PartComponent", new CIMValue((Object)cIMObjectPath2));
            n = new CIMObjectPath(cIMValue.getClassName(), cIMValue.getKeyValuePairs());
            n.setNameSpace("root/ibmhscV3_2");
            CimomWrapper.createInstance(this.cimHandle, (CIMObjectPath)n, (CIMInstance)cIMValue);
        }
        System.out.println("+++++++++ end of updateAllocatedProcessor");
    }

    private void setPollFreq(HscProviderSocket hscProviderSocket) {
        block7: {
            try {
                CIMObjectPath cIMObjectPath = new CIMObjectPath("IBMHSC_Console", "root/ibmhscV3_2");
                CIMClass cIMClass = this.cimHandle.getClass(cIMObjectPath, false);
                Vector vector = CimomWrapper.enumInstances(this.cimHandle, cIMObjectPath, false, cIMClass);
                String string = null;
                cIMObjectPath = null;
                if (vector != null && vector.size() != 0) {
                    cIMObjectPath = (CIMObjectPath)vector.elementAt(0);
                    if ((vector = cIMObjectPath.getKeys()) != null) {
                        Enumeration enumeration = vector.elements();
                        while (enumeration.hasMoreElements()) {
                            CIMProperty cIMProperty = (CIMProperty)enumeration.nextElement();
                            if (!cIMProperty.getName().equalsIgnoreCase(CONSOLE_KEY_NAME)) continue;
                            string = (String)cIMProperty.getValue().getValue();
                            break;
                        }
                    }
                    if (string != null) {
                        System.out.println("The hsc name is   .. " + string);
                    } else {
                        System.out.println("Unable to get the info from hsc console..");
                        Trace.trace("apcshscT", "Unable to get the info from hsc console..");
                    }
                    break block7;
                }
                System.out.println("Unable to get the info from hsc console..");
                System.out.println("FAILED TO ISSUE SET_HSC_POLLING_FREQUENCY COMMAND.");
                Trace.trace("apcshscT", "Unable to get the info from hsc console..");
                Trace.trace("apcshscT", "FAILED TO ISSUE SET_HSC_POLLING_FREQUENCY COMMAND. ");
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
            }
        }
    }

    private void updateSystemProfiles(HscProviderSocket hscProviderSocket, NVRAM nVRAM) throws CIMException {
        String string;
        String string2;
        CIMInstance cIMInstance;
        Object object;
        Object object2;
        Object object3;
        Enumeration<Object> enumeration;
        String string3;
        Object object4;
        Vector vector;
        CIMObjectPath cIMObjectPath = null;
        CIMClass cIMClass = null;
        CIMInstance cIMInstance2 = null;
        System.out.println("+++++++++ updateSystemProfiles");
        Vector vector2 = nVRAM.getAllSysProfiles(hscProviderSocket);
        if (vector2 == null) {
            HscCimObjUtils.deleteCecSystemProfiles(this.eventQueue, this.cimHandle, this.cecObjPath);
            return;
        }
        Hashtable<String, Vector> hashtable = new Hashtable<String, Vector>();
        int n = 0;
        while (n < vector2.size()) {
            vector = (Vector)vector2.elementAt(n);
            object4 = (CIMProperty)vector.elementAt(0);
            string3 = (String)object4.getValue().getValue();
            System.out.println("+++++++++ system profile found in nvram: " + string3);
            hashtable.put(string3, vector);
            n = (short)(n + 1);
        }
        vector = new CIMObjectPath("IBMHSC_CompSysProfile", "root/ibmhscV3_2");
        object4 = CimomWrapper.associators(this.cimHandle, (CIMObjectPath)vector, this.cecObjPath, null, "Element", "Configuration", true, true, null);
        string3 = null;
        if (object4 != null && !((Vector)object4).isEmpty()) {
            enumeration = ((Vector)object4).elements();
            while (enumeration.hasMoreElements()) {
                object3 = (CIMInstance)enumeration.nextElement();
                string3 = object3.filterProperties(null, true, true);
                object2 = (String)string3.getProperty(CONSOLE_KEY_NAME).getValue().getValue();
                System.out.println("++++++++ existing system profile: " + (String)object2);
                object = (Vector)hashtable.get(object2);
                cIMInstance = new CIMObjectPath(string3.getClassName(), string3.getKeyValuePairs());
                cIMInstance.setNameSpace("root/ibmhscV3_2");
                if (object == null) {
                    System.out.println("++++++++ no such system profile: " + (String)object2);
                    HscCimObjUtils.deleteSystemProfile(this.eventQueue, this.cimHandle, (CIMInstance)string3, (CIMObjectPath)cIMInstance, this.cecObjPath);
                    this.eventQueue.add(2, (CIMInstance)string3, null);
                    continue;
                }
                boolean bl = false;
                string2 = (CIMProperty)((Vector)object).elementAt(1);
                string = (String)string2.getValue().getValue();
                string = string.trim();
                System.out.println("++++++++ user defined name: " + string);
                if (CimomWrapper.setPropertyString((CIMInstance)string3, "UserDefinedName", string)) {
                    bl = true;
                }
                if (CimomWrapper.setPropertyString((CIMInstance)string3, "ComputerSystemName", this.cecName)) {
                    bl = true;
                }
                if (CimomWrapper.setPropertyString((CIMInstance)string3, "ComputerSystemCreationClassName", "IBMHSC_ComputerSystem")) {
                    bl = true;
                }
                if (bl) {
                    CimomWrapper.setInstance(this.cimHandle, (CIMObjectPath)cIMInstance, (CIMInstance)string3);
                    this.eventQueue.add(4, (CIMInstance)string3, (CIMInstance)object3);
                }
                this.updateInSysProfiles((Vector)object, (CIMObjectPath)cIMInstance, (String)object2, hscProviderSocket);
                hashtable.remove(object2);
            }
        }
        enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            System.out.println("++++++++ creating new system profile instance");
            object3 = (String)enumeration.nextElement();
            System.out.println("++++++++ new system profile id: " + (String)object3);
            object2 = (Vector)hashtable.get(object3);
            object = new CIMObjectPath("IBMHSC_SystemProfile", "root/ibmhscV3_2");
            cIMInstance = this.cimHandle.getClass((CIMObjectPath)object, false).newInstance();
            cIMInstance.setProperty(CONSOLE_KEY_NAME, new CIMValue(object3));
            CIMProperty cIMProperty = (CIMProperty)((Vector)object2).elementAt(1);
            string2 = (String)cIMProperty.getValue().getValue();
            string2 = string2.trim();
            cIMInstance.setProperty("UserDefinedName", new CIMValue((Object)string2));
            cIMInstance.setProperty("ComputerSystemName", new CIMValue((Object)this.cecName));
            cIMInstance.setProperty("ComputerSystemCreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
            string = new CIMObjectPath(cIMInstance.getClassName(), cIMInstance.getKeyValuePairs());
            string.setNameSpace("root/ibmhscV3_2");
            object = CimomWrapper.createInstance(this.cimHandle, (CIMObjectPath)string, cIMInstance);
            this.updateInSysProfiles((Vector)object2, (CIMObjectPath)object, (String)object3, hscProviderSocket);
            cIMObjectPath = new CIMObjectPath("IBMHSC_CompSysProfile", "root/ibmhscV3_2");
            cIMClass = this.cimHandle.getClass(cIMObjectPath, false);
            cIMInstance2 = cIMClass.newInstance();
            cIMInstance2.setProperty("Element", new CIMValue((Object)this.cecObjPath));
            cIMInstance2.setProperty("Configuration", new CIMValue(object));
            cIMObjectPath = new CIMObjectPath(cIMInstance2.getClassName(), cIMInstance2.getKeyValuePairs());
            cIMObjectPath.setNameSpace("root/ibmhscV3_2");
            CimomWrapper.createInstance(this.cimHandle, cIMObjectPath, cIMInstance2);
            this.eventQueue.add(1, cIMInstance, null);
        }
    }

    private void updateInSysProfiles(Vector vector, CIMObjectPath cIMObjectPath, String string, HscProviderSocket hscProviderSocket) throws CIMException {
        Integer n;
        CIMInstance cIMInstance;
        Object object;
        CIMInstance cIMInstance2;
        CIMObjectPath cIMObjectPath2;
        Object object2;
        Object object3;
        String string2;
        Enumeration<Object> enumeration;
        Object object4;
        String string3;
        System.out.println("+++++++++ updateInSysProfiles");
        CIMProperty cIMProperty = (CIMProperty)vector.elementAt(2);
        Vector vector2 = (Vector)cIMProperty.getValue().getValue();
        if (vector2 == null) {
            CIMObjectPath cIMObjectPath3 = new CIMObjectPath("IBMHSC_InSysProfile", "root/ibmhscV3_2");
            Enumeration enumeration2 = CimomWrapper.referenceNames(this.cimHandle, cIMObjectPath3, cIMObjectPath, null).elements();
            while (enumeration2.hasMoreElements()) {
                CIMObjectPath cIMObjectPath4 = (CIMObjectPath)enumeration2.nextElement();
                CIMInstance cIMInstance3 = CimomWrapper.getInstance(this.cimHandle, cIMObjectPath4, new CIMClass("IBMHSC_InSysProfile"), false);
                System.out.println("+++++++++ delete association: " + cIMObjectPath4);
                CimomWrapper.deleteInstance(this.cimHandle, cIMObjectPath4);
            }
            return;
        }
        CIMProperty cIMProperty2 = (CIMProperty)vector.elementAt(3);
        Vector vector3 = (Vector)cIMProperty2.getValue().getValue();
        Hashtable<String, UnsignedInt8> hashtable = new Hashtable<String, UnsignedInt8>();
        Hashtable<String, Integer> hashtable2 = new Hashtable<String, Integer>();
        int n2 = 0;
        while (n2 < vector2.size()) {
            string3 = (String)vector2.elementAt(n2);
            object4 = (UnsignedInt8)vector3.elementAt(n2);
            hashtable.put(string3, (UnsignedInt8)object4);
            hashtable2.put(string3, new Integer(n2));
            ++n2;
        }
        string3 = new CIMObjectPath("IBMHSC_InSysProfile", "root/ibmhscV3_2");
        object4 = CimomWrapper.associators(this.cimHandle, (CIMObjectPath)string3, cIMObjectPath, null, "Context", "Setting", true, true, null);
        CIMInstance cIMInstance4 = null;
        if (object4 != null && !((Vector)object4).isEmpty()) {
            enumeration = ((Vector)object4).elements();
            block6: while (enumeration.hasMoreElements()) {
                cIMInstance4 = (CIMInstance)enumeration.nextElement();
                string2 = new CIMObjectPath(cIMInstance4.getClassName(), cIMInstance4.getKeyValuePairs());
                string2.setNameSpace("root/ibmhscV3_2");
                object3 = (String)cIMInstance4.getProperty("SettingID").getValue().getValue();
                object2 = (UnsignedInt8)hashtable.get(object3);
                cIMObjectPath2 = new CIMObjectPath("IBMHSC_InSysProfile", "root/ibmhscV3_2");
                cIMInstance2 = CimomWrapper.referenceNames(this.cimHandle, cIMObjectPath2, cIMObjectPath, null).elements();
                if (object2 == null) {
                    while (cIMInstance2.hasMoreElements()) {
                        object = (CIMObjectPath)cIMInstance2.nextElement();
                        System.out.println("+++++++++ check association: " + object);
                        cIMInstance = CimomWrapper.getInstance(this.cimHandle, object, new CIMClass("IBMHSC_InSysProfile"), false);
                        cIMObjectPath2 = (CIMObjectPath)cIMInstance.getProperty("Setting").getValue().getValue();
                        if (!cIMObjectPath2.equals((Object)string2)) continue;
                        System.out.println("+++++++++ delete association: " + object);
                        CimomWrapper.deleteInstance(this.cimHandle, object);
                        continue block6;
                    }
                    continue;
                }
                System.out.println("++++++++ defined lpar profile in system profile: " + (String)object3);
                while (cIMInstance2.hasMoreElements()) {
                    object = (CIMObjectPath)cIMInstance2.nextElement();
                    cIMInstance = CimomWrapper.getInstance(this.cimHandle, object, new CIMClass("IBMHSC_InSysProfile"), false);
                    cIMObjectPath2 = (CIMObjectPath)cIMInstance.getProperty("Setting").getValue().getValue();
                    if (!cIMObjectPath2.equals((Object)string2)) continue;
                    System.out.println("+++++++++ check association: " + object);
                    n = (Integer)hashtable2.get(object3);
                    boolean bl = false;
                    if (CimomWrapper.setProperty(cIMInstance, "ActivateOrder", new UnsignedInt8(n.shortValue()))) {
                        System.out.println("+++++++++ ActivateOrder updated: " + n);
                        bl = true;
                    }
                    if (!bl) break;
                    CimomWrapper.setInstance(this.cimHandle, object, cIMInstance);
                    break;
                }
                hashtable.remove(object3);
            }
        }
        enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            System.out.println("++++++++ creating new InSys instance");
            string2 = (String)enumeration.nextElement();
            object3 = (UnsignedInt8)hashtable.get(string2);
            System.out.println("++++++++ system profile has a new lpar profile: " + string2);
            object2 = null;
            object2 = object3.shortValue() > 9 ? "0" + object3 + "*" + this.cecName : "00" + object3 + "*" + this.cecName;
            cIMObjectPath2 = new CIMObjectPath("IBMHSC_LparProfile", "root/ibmhscV3_2");
            cIMObjectPath2.addKey("SettingID", new CIMValue((Object)string2));
            cIMObjectPath2.addKey("PartitionName", new CIMValue(object2));
            cIMObjectPath2.addKey("PartitionCreationClassName", new CIMValue((Object)"IBMHSC_Partition"));
            cIMObjectPath2.setNameSpace("root/ibmhscV3_2");
            cIMInstance2 = null;
            try {
                cIMInstance2 = CimomWrapper.getInstance(this.cimHandle, cIMObjectPath2, new CIMClass("IBMHSC_LparProfile"), false);
            }
            catch (Throwable throwable) {
                System.out.println("Ignore Exception: " + throwable);
            }
            if (cIMInstance2 == null) {
                System.out.println("the lpar profile is missing. Ingore it.");
                object = new CIMException("Warning: the lpar profile " + string2 + " is missing.");
                HSCLogUtils.serverLog((Throwable)object, HSCLogUtils._CECClassLogInfo);
                try {
                    ((NVRAM)NVRAM.NVRAM_TABLE.get(this.cecName)).deleteLparProfileFromSysProfile(string, string2, hscProviderSocket);
                    System.out.println("delete " + string + "-" + string2);
                }
                catch (Throwable throwable) {
                    System.out.println("oops: " + throwable);
                }
                continue;
            }
            object = new CIMObjectPath("IBMHSC_InSysProfile", "root/ibmhscV3_2");
            cIMInstance = this.cimHandle.getClass(object, false).newInstance();
            cIMInstance.setProperty("Context", new CIMValue((Object)cIMObjectPath));
            cIMInstance.setProperty("Setting", new CIMValue((Object)cIMObjectPath2));
            n = (Integer)hashtable2.get(string2);
            cIMInstance.setProperty("ActivateOrder", new CIMValue((Object)new UnsignedInt8(n.shortValue())));
            object = new CIMObjectPath(cIMInstance.getClassName(), cIMInstance.getKeyValuePairs());
            object.setNameSpace("root/ibmhscV3_2");
            CimomWrapper.createInstance(this.cimHandle, object, cIMInstance);
        }
    }

    private void addNewLparProfile(CIMOMHandle cIMOMHandle, CIMObjectPath cIMObjectPath, Vector vector, HscProviderSocket hscProviderSocket) throws CIMException {
        Object object;
        ProviderCIMOMHandle providerCIMOMHandle = (ProviderCIMOMHandle)cIMOMHandle;
        CIMObjectPath cIMObjectPath2 = null;
        CIMObjectPath cIMObjectPath3 = null;
        CIMClass cIMClass = null;
        CIMInstance cIMInstance = null;
        Vector vector2 = cIMObjectPath.getKeys();
        String string = null;
        if (vector2 != null) {
            object = vector2.elements();
            while (object.hasMoreElements()) {
                CIMProperty cIMProperty = (CIMProperty)object.nextElement();
                if (!cIMProperty.getName().equalsIgnoreCase(CONSOLE_KEY_NAME)) continue;
                string = (String)cIMProperty.getValue().getValue();
                break;
            }
        }
        object = string.substring(string.indexOf(42) + 1);
        short s = Short.parseShort(string.substring(0, 3));
        if (GlobalConfig.debugLevel((int)1) > 0) {
            System.out.println(" the lparID in addLparProfile is ." + s);
            System.out.println("the partition  Name in addLparProfile is" + string);
        }
        Trace.trace("apcshscD", " the lparID in addLparProfile is ." + s);
        Trace.trace("apcshscD", " the partition  Name in addLparProfile is", string);
        CIMObjectPath cIMObjectPath4 = new CIMObjectPath("IBMHSC_ComputerSystem", "root/ibmhscV3_2");
        cIMObjectPath4.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
        cIMObjectPath4.addKey(CONSOLE_KEY_NAME, new CIMValue(object));
        CIMInstance cIMInstance2 = CimomWrapper.getInstance(cIMOMHandle, cIMObjectPath4, cIMOMHandle.getClass(cIMObjectPath4, false), false);
        System.out.println("cspVersion: " + this.cspVersion);
        int n = VersionComparator.CSPVersionValue(this.cspVersion);
        if (!vector.isEmpty()) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                UnsignedInt8 unsignedInt8;
                CIMClass cIMClass2;
                CIMInstance cIMInstance3;
                Object object2;
                CIMObjectPath cIMObjectPath5;
                Object object3;
                Object object4;
                Object object5;
                Object object6;
                UnsignedInt8 unsignedInt82;
                UnsignedInt8 unsignedInt83;
                UnsignedInt8 unsignedInt84;
                UnsignedInt8 unsignedInt85;
                UnsignedInt8 unsignedInt86;
                UnsignedInt8 unsignedInt87;
                String string2;
                String string3;
                CIMProperty cIMProperty;
                Vector vector3 = (Vector)enumeration.nextElement();
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println(" the temp vec with prof is ..." + vector3);
                }
                if (vector3 != null) {
                    Trace.trace("apcshscD", "  the temp vec with prof is ..", vector3.toString());
                }
                if ((float)n >= 3000.0f) {
                    CIMInstance cIMInstance4;
                    Boolean bl;
                    cIMProperty = (CIMProperty)vector3.elementAt(0);
                    string3 = (String)cIMProperty.getValue().getValue();
                    cIMProperty = (CIMProperty)vector3.elementAt(1);
                    string2 = (String)cIMProperty.getValue().getValue();
                    if (GlobalConfig.debugLevel((int)1) > 0) {
                        System.out.println("setting str and the userDefinedName is .." + string3 + " " + string2);
                    }
                    Trace.trace("apcshscD", "setting str is ..", string3);
                    Trace.trace("apcshscD", "userDefinedName is ..", string2);
                    cIMProperty = (CIMProperty)vector3.elementAt(2);
                    unsignedInt87 = (UnsignedInt8)cIMProperty.getValue().getValue();
                    if (GlobalConfig.debugLevel((int)1) > 0) {
                        System.out.println(" the bootMode value is .." + unsignedInt87);
                    }
                    if (unsignedInt87 != null) {
                        Trace.trace("apcshscD", " the bootMode value is ..", unsignedInt87.toString());
                    }
                    cIMProperty = (CIMProperty)vector3.elementAt(3);
                    unsignedInt86 = (UnsignedInt8)cIMProperty.getValue().getValue();
                    cIMProperty = (CIMProperty)vector3.elementAt(4);
                    unsignedInt85 = (UnsignedInt8)cIMProperty.getValue().getValue();
                    cIMProperty = (CIMProperty)vector3.elementAt(5);
                    unsignedInt84 = (UnsignedInt8)cIMProperty.getValue().getValue();
                    cIMProperty = (CIMProperty)vector3.elementAt(6);
                    unsignedInt83 = (UnsignedInt8)cIMProperty.getValue().getValue();
                    cIMProperty = (CIMProperty)vector3.elementAt(7);
                    unsignedInt82 = (UnsignedInt8)cIMProperty.getValue().getValue();
                    cIMProperty = (CIMProperty)vector3.elementAt(8);
                    object6 = (UnsignedInt8)cIMProperty.getValue().getValue();
                    cIMProperty = (CIMProperty)vector3.elementAt(9);
                    object5 = (UnsignedInt32)cIMProperty.getValue().getValue();
                    cIMProperty = (CIMProperty)vector3.elementAt(10);
                    object4 = (UnsignedInt32)cIMProperty.getValue().getValue();
                    cIMProperty = (CIMProperty)vector3.elementAt(11);
                    object3 = (UnsignedInt32)cIMProperty.getValue().getValue();
                    if (GlobalConfig.debugLevel((int)1) > 0) {
                        System.out.println(" before the Drawer info..");
                    }
                    Trace.trace("apcshscD", "before the Drawer info..");
                    cIMProperty = (CIMProperty)vector3.elementAt(12);
                    cIMObjectPath5 = (CIMObjectPath)cIMProperty.getValue().getValue();
                    if (GlobalConfig.debugLevel((int)1) > 0) {
                        System.out.println(" after  the Drawer info.." + cIMObjectPath5);
                    }
                    object2 = null;
                    if (cIMObjectPath5 == null) {
                        object2 = " No IO Drawer/slots  for this profile..";
                        cIMObjectPath5 = new Vector();
                    } else {
                        object2 = cIMObjectPath5.toString();
                    }
                    Trace.trace("apcshscD", " after  the Drawer info..", object2);
                    cIMProperty = (CIMProperty)vector3.elementAt(13);
                    cIMInstance3 = (CIMInstance)cIMProperty.getValue().getValue();
                    if (GlobalConfig.debugLevel((int)1) > 0) {
                        System.out.println(" after  the slots info.." + cIMInstance3);
                    }
                    if (cIMInstance3 == null) {
                        object2 = " No IO Drawer/slots  for this profile..";
                        cIMInstance3 = new Vector();
                    } else {
                        object2 = cIMInstance3.toString();
                    }
                    Trace.trace("apcshscD", "  after  the slots info..", object2);
                    cIMProperty = (CIMProperty)vector3.elementAt(14);
                    cIMClass2 = (CIMClass)cIMProperty.getValue().getValue();
                    if (GlobalConfig.debugLevel((int)1) > 0) {
                        System.out.println(" after  the requried  info.." + cIMClass2);
                    }
                    if (cIMClass2 == null) {
                        object2 = " No IO Drawer/slots  for this profile..";
                        cIMClass2 = new Vector();
                    } else {
                        object2 = cIMClass2.toString();
                    }
                    Trace.trace("apcshscD", " after  the requried  info..", object2);
                    unsignedInt8 = null;
                    Vector vector4 = null;
                    Vector vector5 = null;
                    if ((float)n > 3000.0f) {
                        cIMProperty = (CIMProperty)vector3.elementAt(15);
                        unsignedInt8 = (UnsignedInt8)cIMProperty.getValue().getValue();
                        cIMProperty = (CIMProperty)vector3.elementAt(16);
                        vector4 = (Vector)cIMProperty.getValue().getValue();
                        if (GlobalConfig.debugLevel((int)1) > 0) {
                            System.out.println(" after the SMA adapter IDs..." + vector4);
                        }
                        if (vector4 == null) {
                            object2 = " No SMA Adapters for this profile..";
                            vector4 = new Vector();
                        } else {
                            object2 = vector4.toString();
                        }
                        Trace.trace("apcshscD", " after  the SMA adapter IDs ...", object2);
                        cIMProperty = (CIMProperty)vector3.elementAt(17);
                        vector5 = (Vector)cIMProperty.getValue().getValue();
                        if (GlobalConfig.debugLevel((int)1) > 0) {
                            System.out.println(" after the SMA windows..." + vector5);
                        }
                        if (vector5 == null) {
                            object2 = " No SMA windows for this profile..";
                            vector5 = new Vector();
                        } else {
                            object2 = vector5.toString();
                        }
                        Trace.trace("apcshscD", " after  the SMA windows...", object2);
                    }
                    cIMObjectPath2 = new CIMObjectPath("IBMHSC_LparProfile", "root/ibmhscV3_2");
                    cIMClass = providerCIMOMHandle.getClass(cIMObjectPath2, false);
                    cIMInstance = cIMClass.newInstance();
                    cIMInstance.setProperty("SettingID", new CIMValue((Object)string3));
                    if (GlobalConfig.debugLevel((int)1) > 0) {
                        System.out.println(" before the partion set in the lparProfile.." + string);
                    }
                    Trace.trace("apcshscD", " before the partion set in the lparProfile..", string);
                    cIMInstance.setProperty("PartitionName", new CIMValue((Object)string));
                    cIMInstance.setProperty("UserDefinedName", new CIMValue((Object)string2));
                    cIMInstance.setProperty("PartitionCreationClassName", new CIMValue((Object)"IBMHSC_Partition"));
                    cIMInstance.setProperty("BootMode", new CIMValue((Object)unsignedInt87));
                    cIMInstance.setProperty("ServiceAuthority", new CIMValue((Object)unsignedInt86));
                    cIMInstance.setProperty("RMOSize", new CIMValue((Object)unsignedInt85));
                    cIMInstance.setProperty("SFPSurveillance", new CIMValue((Object)unsignedInt84));
                    if (GlobalConfig.debugLevel((int)1) > 0) {
                        System.out.println(" before assign of the Mem ..");
                    }
                    Trace.trace("apcshscD", " before assign of the Mem ..");
                    cIMInstance.setProperty("DesiredMemoryMB", new CIMValue(object5));
                    cIMInstance.setProperty("MinimumMemoryMB", new CIMValue(object4));
                    cIMInstance.setProperty("MaximumMemoryMB", new CIMValue(object3));
                    if (GlobalConfig.debugLevel((int)1) > 0) {
                        System.out.println(" before assign of the cpus..");
                    }
                    Trace.trace("apcshscD", "before assign of the cpus..");
                    cIMInstance.setProperty("DesiredCPUCount", new CIMValue((Object)unsignedInt83));
                    cIMInstance.setProperty("MinimumCPUCount", new CIMValue((Object)unsignedInt82));
                    cIMInstance.setProperty("MaximumCPUCount", new CIMValue(object6));
                    if (GlobalConfig.debugLevel((int)1) > 0) {
                        System.out.println(" before assign of the IOSlots..");
                    }
                    Trace.trace("apcshscD", "before assign of the IOSlots..");
                    cIMInstance.setProperty("IOSlots", new CIMValue(cIMInstance3, new CIMDataType(21)));
                    cIMInstance.setProperty("IODrawer", new CIMValue((Vector)cIMObjectPath5, new CIMDataType(29)));
                    cIMInstance.setProperty("IORequirement", new CIMValue(cIMClass2, new CIMDataType(29)));
                    if ((float)n > 3000.0f) {
                        cIMInstance.setProperty("SNIConfigMode", new CIMValue((Object)unsignedInt8));
                        cIMInstance.setProperty("SNIDeviceID", new CIMValue(vector4, new CIMDataType(29)));
                        cIMInstance.setProperty("SNIWindows", new CIMValue(vector5, new CIMDataType(23)));
                    }
                    cIMObjectPath3 = new CIMObjectPath(cIMInstance.getClassName(), cIMInstance.getKeyValuePairs());
                    cIMObjectPath3.setNameSpace("root/ibmhscV3_2");
                    if (GlobalConfig.debugLevel((int)1) > 0) {
                        System.out.println(" before creating of the lpar..");
                    }
                    Trace.trace("apcshscD", "before  creating of the lpar..");
                    CIMObjectPath cIMObjectPath6 = CimomWrapper.createInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath3, cIMInstance);
                    this.eventQueue.add(1, cIMInstance, null);
                    if (GlobalConfig.debugLevel((int)1) > 0) {
                        System.out.println(" after  creating of the lpar..");
                    }
                    Trace.trace("apcshscD", " after  creating of the lpar..");
                    cIMObjectPath6 = cIMObjectPath3;
                    if (GlobalConfig.debugLevel((int)1) > 0) {
                        System.out.println(" after the add key, lparProfile is.." + cIMObjectPath6);
                    }
                    Trace.trace("apcshscD", "  after the add key, lparProfile is..", cIMObjectPath6.toString());
                    cIMObjectPath2 = new CIMObjectPath("IBMHSC_PartitionProfile", "root/ibmhscV3_2");
                    cIMClass = providerCIMOMHandle.getClass(cIMObjectPath2, false);
                    cIMInstance = cIMClass.newInstance();
                    cIMInstance.setProperty("Element", new CIMValue((Object)cIMObjectPath));
                    cIMInstance.setProperty("Setting", new CIMValue((Object)cIMObjectPath6));
                    cIMObjectPath3 = new CIMObjectPath(cIMInstance.getClassName(), cIMInstance.getKeyValuePairs());
                    cIMObjectPath3.setNameSpace("root/ibmhscV3_2");
                    if (GlobalConfig.debugLevel((int)1) > 0) {
                        System.out.println(" before the create of asso partiton profile");
                    }
                    Trace.trace("apcshscD", " before the create of asso partiton profile");
                    CimomWrapper.createInstance(cIMOMHandle, cIMObjectPath3, cIMInstance);
                    if (GlobalConfig.debugLevel((int)1) > 0) {
                        System.out.println(" after the create of asso partiton profile");
                    }
                    Trace.trace("apcshscD", " after the create of asso partiton profile");
                    try {
                        cIMProperty = (float)n > 3000.0f ? (CIMProperty)vector3.elementAt(18) : (CIMProperty)vector3.elementAt(15);
                        bl = (Boolean)cIMProperty.getValue().getValue();
                        if (bl.booleanValue()) {
                            this.addNewDefaultLparProfile(cIMOMHandle, cIMObjectPath, cIMObjectPath6);
                        }
                    }
                    catch (Exception exception) {
                        System.out.println(" Excp in Creation of Default Lpar  Profile assocation ");
                        exception.printStackTrace();
                        HSCLogUtils.serverLog(exception, HSCLogUtils._CECClassLogInfo);
                        cIMInstance4 = cIMInstance;
                        cIMInstance4.setProperty("state", new CIMValue((Object)new UnsignedInt8(253)));
                        HscProviderUtils.handleCecInCompleteState(cIMOMHandle, cIMInstance4, cIMInstance, hscProviderSocket);
                    }
                    try {
                        cIMProperty = (float)n > 3000.0f ? (CIMProperty)vector3.elementAt(19) : (CIMProperty)vector3.elementAt(16);
                        bl = (Boolean)cIMProperty.getValue().getValue();
                        if (GlobalConfig.debugLevel((int)1) > 0) {
                            System.out.println(" is activated !!!" + bl);
                        }
                        if (bl != null) {
                            Trace.trace("apcshscD", " is activated !!!", bl.toString());
                        }
                        if (!bl.booleanValue()) continue;
                        cIMInstance4 = new CIMObjectPath("IBMHSC_ActivatedLparProfile", "root/ibmhscV3_2");
                        CIMClass cIMClass3 = providerCIMOMHandle.getClass((CIMObjectPath)cIMInstance4, false);
                        CIMInstance cIMInstance5 = cIMClass3.newInstance();
                        cIMInstance5.setProperty("Element", new CIMValue((Object)cIMObjectPath));
                        cIMInstance5.setProperty("Setting", new CIMValue((Object)cIMObjectPath6));
                        cIMObjectPath3 = new CIMObjectPath(cIMInstance5.getClassName(), cIMInstance5.getKeyValuePairs());
                        cIMObjectPath3.setNameSpace("root/ibmhscV3_2");
                        if (GlobalConfig.debugLevel((int)1) > 0) {
                            System.out.println(" before activate asso creation..");
                        }
                        Trace.trace("apcshscD", " before activate asso creation..");
                        CimomWrapper.createInstance(cIMOMHandle, cIMObjectPath3, cIMInstance5);
                        if (GlobalConfig.debugLevel((int)1) > 0) {
                            System.out.println(" after activate asso creation..");
                        }
                        Trace.trace("apcshscD", "  after activate asso creation..");
                    }
                    catch (Exception exception) {
                        System.out.println(" Excp in Creation of activated Lpar  Profile assocation ");
                        exception.printStackTrace();
                        HSCLogUtils.serverLog(exception, HSCLogUtils._CECClassLogInfo);
                        cIMInstance4 = cIMInstance;
                        cIMInstance4.setProperty("state", new CIMValue((Object)new UnsignedInt8(253)));
                        HscProviderUtils.handleCecInCompleteState(cIMOMHandle, cIMInstance4, cIMInstance, hscProviderSocket);
                    }
                    continue;
                }
                cIMProperty = (CIMProperty)vector3.elementAt(0);
                string3 = (String)cIMProperty.getValue().getValue();
                cIMProperty = (CIMProperty)vector3.elementAt(1);
                string2 = (String)cIMProperty.getValue().getValue();
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println("setting str and the userDefinedName is .." + string3 + " " + string2);
                }
                Trace.trace("apcshscD", "setting str is ..", string3);
                Trace.trace("apcshscD", "userDefinedName is ..", string2);
                cIMProperty = (CIMProperty)vector3.elementAt(2);
                unsignedInt87 = (UnsignedInt8)cIMProperty.getValue().getValue();
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println(" the bootMode value is .." + unsignedInt87);
                }
                if (unsignedInt87 != null) {
                    Trace.trace("apcshscD", " the bootMode value is ..", unsignedInt87.toString());
                }
                cIMProperty = (CIMProperty)vector3.elementAt(3);
                unsignedInt86 = (UnsignedInt8)cIMProperty.getValue().getValue();
                cIMProperty = (CIMProperty)vector3.elementAt(4);
                unsignedInt85 = (UnsignedInt8)cIMProperty.getValue().getValue();
                cIMProperty = (CIMProperty)vector3.elementAt(5);
                unsignedInt84 = (UnsignedInt8)cIMProperty.getValue().getValue();
                cIMProperty = (CIMProperty)vector3.elementAt(6);
                unsignedInt83 = (UnsignedInt32)cIMProperty.getValue().getValue();
                cIMProperty = (CIMProperty)vector3.elementAt(7);
                unsignedInt82 = (UnsignedInt32)cIMProperty.getValue().getValue();
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println(" before the Drawer info..");
                }
                Trace.trace("apcshscD", "before the Drawer info..");
                cIMProperty = (CIMProperty)vector3.elementAt(8);
                object6 = (Vector)cIMProperty.getValue().getValue();
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println(" after  the Drawer info.." + object6);
                }
                object5 = null;
                if (object6 == null) {
                    object5 = " No IO Drawer/slots  for this profile..";
                    object6 = new Vector();
                } else {
                    object5 = ((Vector)object6).toString();
                }
                Trace.trace("apcshscD", " after  the Drawer info..", object5);
                cIMProperty = (CIMProperty)vector3.elementAt(9);
                object4 = (Vector)cIMProperty.getValue().getValue();
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println(" after  the slots info.." + object4);
                }
                if (object4 == null) {
                    object5 = " No IO Drawer/slots  for this profile..";
                    object4 = new Vector();
                } else {
                    object5 = ((Vector)object4).toString();
                }
                Trace.trace("apcshscD", "  after  the slots info..", object5);
                cIMProperty = (CIMProperty)vector3.elementAt(10);
                object3 = (Vector)cIMProperty.getValue().getValue();
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println(" after  the requried  info.." + object3);
                }
                if (object3 == null) {
                    object5 = " No IO Drawer/slots  for this profile..";
                    object3 = new Vector();
                } else {
                    object5 = ((Vector)object3).toString();
                }
                Trace.trace("apcshscD", " after  the requried  info..", object5);
                cIMObjectPath2 = new CIMObjectPath("IBMHSC_LparProfile", "root/ibmhscV3_2");
                cIMClass = providerCIMOMHandle.getClass(cIMObjectPath2, false);
                cIMInstance = cIMClass.newInstance();
                cIMInstance.setProperty("SettingID", new CIMValue((Object)string3));
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println(" before the partion set in the lparProfile.." + string);
                }
                Trace.trace("apcshscD", " before the partion set in the lparProfile..", string);
                cIMInstance.setProperty("PartitionName", new CIMValue((Object)string));
                cIMInstance.setProperty("UserDefinedName", new CIMValue((Object)string2));
                cIMInstance.setProperty("PartitionCreationClassName", new CIMValue((Object)"IBMHSC_Partition"));
                cIMInstance.setProperty("BootMode", new CIMValue((Object)unsignedInt87));
                cIMInstance.setProperty("ServiceAuthority", new CIMValue((Object)unsignedInt86));
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println(" before assign of the Mem ..");
                }
                Trace.trace("apcshscD", " before assign of the Mem ..");
                cIMInstance.setProperty("DesiredMemoryMB", new CIMValue((Object)unsignedInt83));
                cIMInstance.setProperty("MinimumMemoryMB", new CIMValue((Object)unsignedInt82));
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println(" before assign of the cpus..");
                }
                Trace.trace("apcshscD", "before assign of the cpus..");
                cIMInstance.setProperty("DesiredCPUCount", new CIMValue((Object)unsignedInt85));
                cIMInstance.setProperty("MinimumCPUCount", new CIMValue((Object)unsignedInt84));
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println(" before assign of the IOSlots..");
                }
                Trace.trace("apcshscD", "before assign of the IOSlots..");
                cIMInstance.setProperty("IOSlots", new CIMValue((Vector)object4, new CIMDataType(21)));
                cIMInstance.setProperty("IODrawer", new CIMValue((Vector)object6, new CIMDataType(29)));
                cIMInstance.setProperty("IORequirement", new CIMValue((Vector)object3, new CIMDataType(29)));
                cIMObjectPath3 = new CIMObjectPath(cIMInstance.getClassName(), cIMInstance.getKeyValuePairs());
                cIMObjectPath3.setNameSpace("root/ibmhscV3_2");
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println(" before creating of the lpar..");
                }
                Trace.trace("apcshscD", "before  creating of the lpar..");
                cIMObjectPath5 = CimomWrapper.createInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath3, cIMInstance);
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println(" after  creating of the lpar..");
                }
                Trace.trace("apcshscD", " after  creating of the lpar..");
                cIMObjectPath5 = cIMObjectPath3;
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println(" after the add key, lparProfile is.." + cIMObjectPath5);
                }
                Trace.trace("apcshscD", "  after the add key, lparProfile is..", cIMObjectPath5.toString());
                cIMObjectPath2 = new CIMObjectPath("IBMHSC_PartitionProfile", "root/ibmhscV3_2");
                cIMClass = providerCIMOMHandle.getClass(cIMObjectPath2, false);
                cIMInstance = cIMClass.newInstance();
                cIMInstance.setProperty("Element", new CIMValue((Object)cIMObjectPath));
                cIMInstance.setProperty("Setting", new CIMValue((Object)cIMObjectPath5));
                cIMObjectPath3 = new CIMObjectPath(cIMInstance.getClassName(), cIMInstance.getKeyValuePairs());
                cIMObjectPath3.setNameSpace("root/ibmhscV3_2");
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println(" before the create of asso partiton profile");
                }
                Trace.trace("apcshscD", " before the create of asso partiton profile");
                CimomWrapper.createInstance(cIMOMHandle, cIMObjectPath3, cIMInstance);
                if (GlobalConfig.debugLevel((int)1) > 0) {
                    System.out.println(" after the create of asso partiton profile");
                }
                Trace.trace("apcshscD", " after the create of asso partiton profile");
                try {
                    cIMProperty = (CIMProperty)vector3.elementAt(11);
                    object2 = (Boolean)cIMProperty.getValue().getValue();
                    if (((Boolean)object2).booleanValue()) {
                        this.addNewDefaultLparProfile(cIMOMHandle, cIMObjectPath, cIMObjectPath5);
                    }
                }
                catch (Exception exception) {
                    System.out.println(" Excp in Creation of Default Lpar  Profile assocation ");
                    exception.printStackTrace();
                    HSCLogUtils.serverLog(exception, HSCLogUtils._CECClassLogInfo);
                    cIMInstance3 = cIMInstance;
                    cIMInstance3.setProperty("state", new CIMValue((Object)new UnsignedInt8(253)));
                    HscProviderUtils.handleCecInCompleteState(cIMOMHandle, cIMInstance3, cIMInstance, hscProviderSocket);
                }
                try {
                    cIMProperty = (CIMProperty)vector3.elementAt(12);
                    object2 = (Boolean)cIMProperty.getValue().getValue();
                    if (GlobalConfig.debugLevel((int)1) > 0) {
                        System.out.println(" is activated !!!" + object2);
                    }
                    if (object2 != null) {
                        Trace.trace("apcshscD", " is activated !!!", ((Boolean)object2).toString());
                    }
                    if (!((Boolean)object2).booleanValue()) continue;
                    cIMInstance3 = new CIMObjectPath("IBMHSC_ActivatedLparProfile", "root/ibmhscV3_2");
                    cIMClass2 = providerCIMOMHandle.getClass((CIMObjectPath)cIMInstance3, false);
                    unsignedInt8 = cIMClass2.newInstance();
                    unsignedInt8.setProperty("Element", new CIMValue((Object)cIMObjectPath));
                    unsignedInt8.setProperty("Setting", new CIMValue((Object)cIMObjectPath5));
                    cIMObjectPath3 = new CIMObjectPath(unsignedInt8.getClassName(), unsignedInt8.getKeyValuePairs());
                    cIMObjectPath3.setNameSpace("root/ibmhscV3_2");
                    if (GlobalConfig.debugLevel((int)1) > 0) {
                        System.out.println(" before activate asso creation..");
                    }
                    Trace.trace("apcshscD", " before activate asso creation..");
                    CimomWrapper.createInstance(cIMOMHandle, cIMObjectPath3, (CIMInstance)unsignedInt8);
                    if (GlobalConfig.debugLevel((int)1) > 0) {
                        System.out.println(" after activate asso creation..");
                    }
                    Trace.trace("apcshscD", "  after activate asso creation..");
                }
                catch (Exception exception) {
                    System.out.println(" Excp in Creation of activated Lpar  Profile assocation ");
                    exception.printStackTrace();
                    HSCLogUtils.serverLog(exception, HSCLogUtils._CECClassLogInfo);
                    cIMInstance3 = cIMInstance;
                    cIMInstance3.setProperty("state", new CIMValue((Object)new UnsignedInt8(253)));
                    HscProviderUtils.handleCecInCompleteState(cIMOMHandle, cIMInstance3, cIMInstance, hscProviderSocket);
                }
            }
        }
    }

    private void addNewDefaultLparProfile(CIMOMHandle cIMOMHandle, CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2) throws CIMException {
        ProviderCIMOMHandle providerCIMOMHandle = (ProviderCIMOMHandle)cIMOMHandle;
        CIMObjectPath cIMObjectPath3 = new CIMObjectPath("IBMHSC_DefaultLparProfile", "root/ibmhscV3_2");
        CIMClass cIMClass = cIMOMHandle.getClass(cIMObjectPath3, false);
        CIMInstance cIMInstance = cIMClass.newInstance();
        cIMInstance.setProperty("Element", new CIMValue((Object)cIMObjectPath));
        cIMInstance.setProperty("Setting", new CIMValue((Object)cIMObjectPath2));
        CIMObjectPath cIMObjectPath4 = new CIMObjectPath(cIMInstance.getClassName(), cIMInstance.getKeyValuePairs());
        cIMObjectPath4.setNameSpace("root/ibmhscV3_2");
        System.out.println(" before the default lpar creation..");
        CimomWrapper.createInstance(cIMOMHandle, cIMObjectPath4, cIMInstance);
        System.out.println(" after  the default lpar creation..");
    }

    private void deleteFrameCecAsso(CIMInstance cIMInstance, CIMObjectPath cIMObjectPath) throws CIMException {
        FrameUtils.deleteCecFrameAsso(this.cimHandle, cIMInstance, this.eventQueue);
        this.deletedFrameCecAssoInst = cIMInstance;
    }

    private CIMObjectPath checkBPAConn(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        CIMObjectPath cIMObjectPath2 = (CIMObjectPath)cIMInstance.getProperty("GroupComponent").getValue().getValue();
        CIMInstance cIMInstance2 = CimomWrapper.getInstance(this.cimHandle, cIMObjectPath2, this.cimHandle.getClass(cIMObjectPath2, false), false);
        UnsignedInt16 unsignedInt16 = (UnsignedInt16)cIMInstance2.getProperty("frameType").getValue().getValue();
        int n = unsignedInt16.intValue();
        if (n != 0 && n != 1 && n != 2) {
            return null;
        }
        CIMInstance cIMInstance3 = CimomWrapper.getInstance(this.cimHandle, cIMObjectPath, this.cimHandle.getClass(cIMObjectPath, false), false);
        String string = (String)cIMInstance3.getProperty(CONSOLE_KEY_NAME).getValue().getValue();
        try {
            Hashtable hashtable = FrameUtils.getFrameInfo(cIMInstance2);
            String[] stringArray = (String[])hashtable.get("mtms");
            int n2 = 1;
            while (n2 < 17) {
                if (stringArray[n2] != null && stringArray[n2].equals(string)) {
                    return cIMObjectPath2;
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            HSCLogUtils.serverLog(exception, HSCLogUtils._FrameClassLogInfo);
        }
        return null;
    }

    private CIMObjectPath updateFrameInstance(String string, int n, boolean bl, int n2) throws CIMException {
        System.out.println("+++++++++ updateFrameInstance");
        System.out.println("+++++++++ Name: " + string);
        CIMObjectPath cIMObjectPath = new CIMObjectPath("IBMHSC_Frame", "root/ibmhscV3_2");
        cIMObjectPath.addKey(CONSOLE_KEY_NAME, new CIMValue((Object)string));
        cIMObjectPath.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_Frame"));
        this.frameInst = null;
        try {
            this.frameInst = CimomWrapper.getInstance(this.cimHandle, cIMObjectPath, this.cimHandle.getClass(cIMObjectPath, false), false);
        }
        catch (CIMException cIMException) {
            System.out.println("+++++++++ frame instance: " + cIMObjectPath + " not found");
            this.frameInst = null;
        }
        if (this.frameInst == null) {
            CIMInstance cIMInstance;
            CIMObjectPath cIMObjectPath2;
            CIMObjectPath cIMObjectPath3 = new CIMObjectPath("IBMHSC_FrameCompSys", "root/ibmhscV3_2");
            Enumeration enumeration = CimomWrapper.referenceNames(this.cimHandle, cIMObjectPath3, this.cecObjPath, null).elements();
            boolean bl2 = false;
            CIMObjectPath cIMObjectPath4 = null;
            while (enumeration.hasMoreElements()) {
                cIMObjectPath2 = (CIMObjectPath)enumeration.nextElement();
                cIMInstance = CimomWrapper.getInstance(this.cimHandle, cIMObjectPath2, new CIMClass("IBMHSC_FrameCompSys"), false);
                System.out.println("+++++++++ delete frame-cec asso: " + cIMObjectPath2);
                if (!bl2 && (cIMObjectPath4 = this.checkBPAConn(this.cecObjPath, cIMInstance)) != null) {
                    bl2 = true;
                    continue;
                }
                this.deleteFrameCecAsso(cIMInstance, cIMObjectPath2);
            }
            if (bl2) {
                return cIMObjectPath4;
            }
            System.out.println("++++++ creating the frame instance");
            cIMObjectPath2 = this.cimHandle.getClass(cIMObjectPath, false);
            this.frameInst = cIMObjectPath2.newInstance();
            this.frameInst.setProperty("CreationClassName", new CIMValue((Object)"IBMHSC_Frame"));
            this.frameInst.setProperty(CONSOLE_KEY_NAME, new CIMValue((Object)string));
            this.frameInst.setProperty("isFrame", new CIMValue((Object)new Boolean(bl)));
            this.frameInst.setProperty("FrameNumber", new CIMValue((Object)new UnsignedInt16(n)));
            this.frameInst.setProperty("frameType", new CIMValue((Object)new UnsignedInt16(n2)));
            cIMInstance = new CIMObjectPath(this.frameInst.getClassName(), this.frameInst.getKeyValuePairs());
            cIMInstance.setNameSpace("root/ibmhscV3_2");
            cIMObjectPath = CimomWrapper.createInstance(this.cimHandle, (CIMObjectPath)cIMInstance, this.frameInst);
            this.frameEvent = 1;
        } else {
            CIMObjectPath cIMObjectPath5 = new CIMObjectPath(this.frameInst.getClassName(), this.frameInst.getKeyValuePairs());
            cIMObjectPath5.setNameSpace("root/ibmhscV3_2");
            CIMInstance cIMInstance = this.frameInst.filterProperties(null, true, true);
            boolean bl3 = false;
            UnsignedInt16 unsignedInt16 = (UnsignedInt16)this.frameInst.getProperty("frameType").getValue().getValue();
            int n3 = unsignedInt16.intValue();
            if (n3 != 0 && n3 != 1 && n3 != 2 && n2 != unsignedInt16.intValue()) {
                cIMInstance.setProperty("frameType", new CIMValue((Object)new UnsignedInt16(n2)));
                bl3 = true;
            }
            if (bl3) {
                CimomWrapper.setInstance(this.cimHandle, cIMObjectPath5, cIMInstance);
                this.eventQueue.add(4, cIMInstance, this.frameInst);
            }
        }
        return cIMObjectPath;
    }

    private void updateFrameCecAss(CIMObjectPath cIMObjectPath) throws CIMException {
        CIMObjectPath cIMObjectPath2;
        CIMInstance cIMInstance;
        CIMObjectPath cIMObjectPath3;
        boolean bl = false;
        CIMObjectPath cIMObjectPath4 = new CIMObjectPath("IBMHSC_FrameCompSys", "root/ibmhscV3_2");
        Enumeration enumeration = null;
        try {
            enumeration = CimomWrapper.referenceNames(this.cimHandle, cIMObjectPath4, this.cecObjPath, null).elements();
        }
        catch (Throwable throwable) {
            System.out.println("++++++ frame/cec association not found");
            enumeration = null;
        }
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                cIMObjectPath3 = (CIMObjectPath)enumeration.nextElement();
                System.out.println("+++++++++ check association: " + cIMObjectPath3);
                cIMInstance = CimomWrapper.getInstance(this.cimHandle, cIMObjectPath3, new CIMClass("IBMHSC_FrameCompSys"), false);
                cIMObjectPath2 = (CIMObjectPath)cIMInstance.getProperty("GroupComponent").getValue().getValue();
                if (cIMObjectPath2.equals((Object)cIMObjectPath)) {
                    bl = true;
                    continue;
                }
                System.out.println("+++++++++ delete existing frame-cec asso: " + cIMObjectPath3);
                this.deleteFrameCecAsso(cIMInstance, cIMObjectPath3);
            }
        }
        if (!bl) {
            cIMObjectPath3 = this.cimHandle.getClass(cIMObjectPath4, false);
            cIMInstance = cIMObjectPath3.newInstance();
            cIMInstance.setProperty("GroupComponent", new CIMValue((Object)cIMObjectPath));
            cIMInstance.setProperty("PartComponent", new CIMValue((Object)this.cecObjPath));
            cIMObjectPath2 = new CIMObjectPath(cIMInstance.getClassName(), cIMInstance.getKeyValuePairs());
            cIMObjectPath2.setNameSpace("root/ibmhscV3_2");
            System.out.println("++++++ creating the Association between the Frame & CEC");
            CimomWrapper.createInstance(this.cimHandle, cIMObjectPath2, cIMInstance);
            this.addedFrameCecAssoInst = cIMInstance;
        }
    }

    private CIMObjectPath updateFrame(int n, HscProviderSocket hscProviderSocket) throws CIMException {
        boolean bl = false;
        Hashtable hashtable = null;
        String string = null;
        int n2 = 0;
        int n3 = 4;
        if ((n & 0x40) == 64) {
            Object object;
            try {
                hashtable = HscProviderUtils.doCSPCommand("GET_BPA_TYPE_SERIAL_NO", null, hscProviderSocket, this.cspVersion);
                System.out.println("Can get the Frame's MTMS");
                System.out.println("Build a real frame");
                String string2 = (String)hashtable.get("BPA_TYPE");
                object = (String)hashtable.get("SERIAL_NO");
                System.out.println("The BPA model type is :" + string2);
                System.out.println("The BPA serial num is :" + (String)object);
                String string3 = string2.concat("*");
                string = string3.concat((String)object);
                System.out.println("The BPA MTMS is :" + string);
                n3 = 5;
            }
            catch (Throwable throwable) {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
                System.out.println("++++++ can not get the Frame's MTMS");
                System.out.println("++++++ we should have a dummy IH frame");
                string = "UNKNOWN*FRAME";
                n3 = 3;
            }
            try {
                int n4 = VersionComparator.CSPVersionValue(this.cspVersion);
                if ((float)n4 > 3000.0f) {
                    hashtable = HscProviderUtils.doCSPCommand("GET_FRAME_NUMBER", null, hscProviderSocket, this.cspVersion);
                    object = (Integer)hashtable.get("FRAME_NUMBER");
                    n2 = (Integer)object;
                }
            }
            catch (Throwable throwable) {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
                n2 = 0;
            }
        } else {
            System.out.println("Regatta H not part of a frame");
            System.out.println("it is a regatta H dummy frame");
            string = "F".concat(this.cecName);
        }
        CIMObjectPath cIMObjectPath = null;
        try {
            cIMObjectPath = this.updateFrameInstance(string, n2, bl, n3);
            FrameUtils.setFrameNumToCec(this.cimHandle, cIMObjectPath, hscProviderSocket, this.cspVersion, this.rebuildFlag != 0);
            this.updateFrameCecAss(cIMObjectPath);
        }
        catch (Throwable throwable) {
            System.out.println("++++++ error updating frame instance and association");
            throwable.printStackTrace();
        }
        return cIMObjectPath;
    }

    private void createSmpPartition(HscProviderSocket hscProviderSocket) throws CIMException {
        try {
            String string;
            String[] stringArray;
            CIMObjectPath cIMObjectPath = new CIMObjectPath("IBMHSC_CompSysPartition", "root/ibmhscV3_2");
            Vector vector = null;
            try {
                vector = CimomWrapper.associators(this.cimHandle, cIMObjectPath, this.cecObjPath, null, "GroupComponent", "PartComponent", true, true, null);
            }
            catch (Throwable throwable) {
                System.out.println("no partition exists!");
                throwable.printStackTrace();
                vector = null;
            }
            if (vector != null && !vector.isEmpty()) {
                stringArray = vector.elements();
                while (stringArray.hasMoreElements()) {
                    CIMInstance cIMInstance = (CIMInstance)stringArray.nextElement();
                    string = (String)cIMInstance.getProperty(CONSOLE_KEY_NAME).getValue().getValue();
                    short s = Short.parseShort(string.substring(0, 3));
                    if (s != 0) continue;
                    System.out.println("++++++full system partition already exists!");
                    return;
                }
            }
            System.out.println("++++++full system partition does not exist. Now creating...");
            stringArray = new String[1];
            short s = 0;
            stringArray[0] = Integer.toHexString(s);
            if (this.rebuildFlag == 0) {
                ComputerSystemProvUtils.closeVTTYTerminal(hscProviderSocket, stringArray, s);
            }
            cIMObjectPath = new CIMObjectPath("IBMHSC_Partition", "root/ibmhscV3_2");
            string = this.cimHandle.getClass(cIMObjectPath, false);
            CIMInstance cIMInstance = string.newInstance();
            String string2 = "000*" + this.cecName;
            cIMInstance.setProperty(CONSOLE_KEY_NAME, new CIMValue((Object)string2));
            cIMInstance.setProperty("UserDefinedName", new CIMValue((Object)"FullSystemPartition"));
            cIMInstance.setProperty("CreationClassName", new CIMValue((Object)"IBMHSC_Partition"));
            cIMInstance.setProperty("Editable", CIMValue.FALSE);
            cIMInstance.setProperty("PartitionType", new CIMValue((Object)new UnsignedInt8(0)));
            short s2 = -1;
            if (this.cecMode == 255) {
                s2 = 252;
            } else if (this.cecState == 3) {
                s2 = 252;
            } else if (this.cecState == 1) {
                s2 = 8;
            }
            cIMInstance.setProperty("PartitionState", new CIMValue((Object)new UnsignedInt8(s2)));
            CIMObjectPath cIMObjectPath2 = new CIMObjectPath(cIMInstance.getClassName(), cIMInstance.getKeyValuePairs());
            cIMObjectPath2.setNameSpace("root/ibmhscV3_2");
            CIMObjectPath cIMObjectPath3 = CimomWrapper.createInstance(this.cimHandle, cIMObjectPath2, cIMInstance);
            this.eventQueue.add(1, cIMInstance, null);
            if (cIMObjectPath3 != null) {
                Trace.trace("apcshscD", "after  the partition creation...", cIMObjectPath3.toString());
            }
            cIMObjectPath3 = cIMObjectPath2;
            cIMObjectPath = new CIMObjectPath("IBMHSC_CompSysPartition", "root/ibmhscV3_2");
            string = this.cimHandle.getClass(cIMObjectPath, false);
            cIMInstance = string.newInstance();
            cIMInstance.setProperty("PartComponent", new CIMValue((Object)cIMObjectPath3));
            cIMInstance.setProperty("GroupComponent", new CIMValue((Object)this.cecObjPath));
            cIMObjectPath2 = new CIMObjectPath(cIMInstance.getClassName(), cIMInstance.getKeyValuePairs());
            cIMObjectPath2.setNameSpace("root/ibmhscV3_2");
            CimomWrapper.createInstance(this.cimHandle, cIMObjectPath2, cIMInstance);
            cIMObjectPath = new CIMObjectPath("IBMHSC_LparProfile", "root/ibmhscV3_2");
            CIMObjectPath cIMObjectPath4 = new CIMObjectPath("IBMHSC_PartitionProfile", "root/ibmhscV3_2");
            String string3 = "1111/1/1/1/1/1";
            string = this.cimHandle.getClass(cIMObjectPath, false);
            cIMInstance = string.newInstance();
            cIMInstance.setProperty("PartitionCreationClassName", new CIMValue((Object)"IBMHSC_Partition"));
            cIMInstance.setProperty("PartitionName", new CIMValue((Object)string2));
            cIMInstance.setProperty("SettingID", new CIMValue((Object)string3));
            cIMInstance.setProperty("BootMode", new CIMValue((Object)new UnsignedInt8(1)));
            cIMInstance.setProperty("UserDefinedName", new CIMValue((Object)"PowerOnNormalProfile"));
            cIMObjectPath2 = new CIMObjectPath(cIMInstance.getClassName(), cIMInstance.getKeyValuePairs());
            cIMObjectPath2.setNameSpace("root/ibmhscV3_2");
            CIMObjectPath cIMObjectPath5 = CimomWrapper.createInstance(this.cimHandle, cIMObjectPath2, cIMInstance);
            this.eventQueue.add(1, cIMInstance, null);
            cIMObjectPath5 = cIMObjectPath2;
            string = this.cimHandle.getClass(cIMObjectPath4, false);
            CIMInstance cIMInstance2 = string.newInstance();
            cIMInstance2.setProperty("Element", new CIMValue((Object)cIMObjectPath3));
            cIMInstance2.setProperty("Setting", new CIMValue((Object)cIMObjectPath5));
            cIMObjectPath2 = new CIMObjectPath(cIMInstance2.getClassName(), cIMInstance2.getKeyValuePairs());
            cIMObjectPath2.setNameSpace("root/ibmhscV3_2");
            CimomWrapper.createInstance(this.cimHandle, cIMObjectPath2, cIMInstance2);
            try {
                ComputerSystemProvUtils.addDefaultLparProfile(this.cimHandle, cIMObjectPath3, cIMObjectPath5);
            }
            catch (Exception exception) {
                System.out.println(" Excp in Creation of Default Lpar Profile assocation ");
                Trace.trace("apcshscT", "Excp in Creation of Default Lpar Profile + association");
                exception.printStackTrace();
                HSCLogUtils.serverLog(exception, HSCLogUtils._CECClassLogInfo);
                this.cecInst.setProperty("state", new CIMValue((Object)new UnsignedInt8(253)));
                HscProviderUtils.handleCecInCompleteState(this.cimHandle, this.cecInst, this.cecInst, hscProviderSocket);
            }
            string3 = "2222/2/2/2/2/2";
            string = this.cimHandle.getClass(cIMObjectPath, false);
            cIMInstance = string.newInstance();
            cIMInstance.setProperty("PartitionCreationClassName", new CIMValue((Object)"IBMHSC_Partition"));
            cIMInstance.setProperty("PartitionName", new CIMValue((Object)string2));
            cIMInstance.setProperty("BootMode", new CIMValue((Object)new UnsignedInt8(2)));
            cIMInstance.setProperty("SettingID", new CIMValue((Object)string3));
            cIMInstance.setProperty("UserDefinedName", new CIMValue((Object)"PowerOnDiagnosticDefaultBootListProfile"));
            cIMObjectPath2 = new CIMObjectPath(cIMInstance.getClassName(), cIMInstance.getKeyValuePairs());
            cIMObjectPath2.setNameSpace("root/ibmhscV3_2");
            CimomWrapper.createInstance(this.cimHandle, cIMObjectPath2, cIMInstance);
            this.eventQueue.add(1, cIMInstance, null);
            cIMObjectPath5 = cIMObjectPath2;
            string = this.cimHandle.getClass(cIMObjectPath4, false);
            cIMInstance2 = string.newInstance();
            cIMInstance2.setProperty("Element", new CIMValue((Object)cIMObjectPath3));
            cIMInstance2.setProperty("Setting", new CIMValue((Object)cIMObjectPath5));
            cIMObjectPath2 = new CIMObjectPath(cIMInstance2.getClassName(), cIMInstance2.getKeyValuePairs());
            cIMObjectPath2.setNameSpace("root/ibmhscV3_2");
            CimomWrapper.createInstance(this.cimHandle, cIMObjectPath2, cIMInstance2);
            string3 = "3333/3/3/3/3/3";
            string = this.cimHandle.getClass(cIMObjectPath, false);
            cIMInstance = string.newInstance();
            cIMInstance.setProperty("PartitionCreationClassName", new CIMValue((Object)"IBMHSC_Partition"));
            cIMInstance.setProperty("PartitionName", new CIMValue((Object)string2));
            cIMInstance.setProperty("BootMode", new CIMValue((Object)new UnsignedInt8(3)));
            cIMInstance.setProperty("SettingID", new CIMValue((Object)string3));
            cIMInstance.setProperty("UserDefinedName", new CIMValue((Object)"PowerOnSMSProfile"));
            cIMObjectPath2 = new CIMObjectPath(cIMInstance.getClassName(), cIMInstance.getKeyValuePairs());
            cIMObjectPath2.setNameSpace("root/ibmhscV3_2");
            CimomWrapper.createInstance(this.cimHandle, cIMObjectPath2, cIMInstance);
            this.eventQueue.add(1, cIMInstance, null);
            cIMObjectPath5 = cIMObjectPath2;
            System.out.println("+++++++profileObjPath = " + cIMObjectPath5);
            string = this.cimHandle.getClass(cIMObjectPath4, false);
            cIMInstance2 = string.newInstance();
            cIMInstance2.setProperty("Element", new CIMValue((Object)cIMObjectPath3));
            cIMInstance2.setProperty("Setting", new CIMValue((Object)cIMObjectPath5));
            cIMObjectPath2 = new CIMObjectPath(cIMInstance2.getClassName(), cIMInstance2.getKeyValuePairs());
            cIMObjectPath2.setNameSpace("root/ibmhscV3_2");
            CimomWrapper.createInstance(this.cimHandle, cIMObjectPath2, cIMInstance2);
            string3 = "4444/4/4/4/4/4";
            string = this.cimHandle.getClass(cIMObjectPath, false);
            cIMInstance = string.newInstance();
            cIMInstance.setProperty("PartitionCreationClassName", new CIMValue((Object)"IBMHSC_Partition"));
            cIMInstance.setProperty("PartitionName", new CIMValue((Object)string2));
            cIMInstance.setProperty("BootMode", new CIMValue((Object)new UnsignedInt8(4)));
            cIMInstance.setProperty("SettingID", new CIMValue((Object)string3));
            cIMInstance.setProperty("UserDefinedName", new CIMValue((Object)"PowerOnOpenFirmwareOKPromptProfile"));
            cIMObjectPath2 = new CIMObjectPath(cIMInstance.getClassName(), cIMInstance.getKeyValuePairs());
            cIMObjectPath2.setNameSpace("root/ibmhscV3_2");
            CimomWrapper.createInstance(this.cimHandle, cIMObjectPath2, cIMInstance);
            this.eventQueue.add(1, cIMInstance, null);
            cIMObjectPath5 = cIMObjectPath2;
            string = this.cimHandle.getClass(cIMObjectPath4, false);
            cIMInstance2 = string.newInstance();
            cIMInstance2.setProperty("Element", new CIMValue((Object)cIMObjectPath3));
            cIMInstance2.setProperty("Setting", new CIMValue((Object)cIMObjectPath5));
            cIMObjectPath2 = new CIMObjectPath(cIMInstance2.getClassName(), cIMInstance2.getKeyValuePairs());
            cIMObjectPath2.setNameSpace("root/ibmhscV3_2");
            CimomWrapper.createInstance(this.cimHandle, cIMObjectPath2, cIMInstance2);
            string3 = "5555/5/5/5/5/5";
            string = this.cimHandle.getClass(cIMObjectPath, false);
            cIMInstance = string.newInstance();
            cIMInstance.setProperty("PartitionCreationClassName", new CIMValue((Object)"IBMHSC_Partition"));
            cIMInstance.setProperty("PartitionName", new CIMValue((Object)string2));
            cIMInstance.setProperty("BootMode", new CIMValue((Object)new UnsignedInt8(5)));
            cIMInstance.setProperty("SettingID", new CIMValue((Object)string3));
            cIMInstance.setProperty("UserDefinedName", new CIMValue((Object)"PowerOnDiagnosticStoredBootListProfile"));
            cIMObjectPath2 = new CIMObjectPath(cIMInstance.getClassName(), cIMInstance.getKeyValuePairs());
            cIMObjectPath2.setNameSpace("root/ibmhscV3_2");
            CimomWrapper.createInstance(this.cimHandle, cIMObjectPath2, cIMInstance);
            this.eventQueue.add(1, cIMInstance, null);
            cIMObjectPath5 = cIMObjectPath2;
            string = this.cimHandle.getClass(cIMObjectPath4, false);
            cIMInstance2 = string.newInstance();
            cIMInstance2.setProperty("Element", new CIMValue((Object)cIMObjectPath3));
            cIMInstance2.setProperty("Setting", new CIMValue((Object)cIMObjectPath5));
            cIMObjectPath2 = new CIMObjectPath(cIMInstance2.getClassName(), cIMInstance2.getKeyValuePairs());
            cIMObjectPath2.setNameSpace("root/ibmhscV3_2");
            CimomWrapper.createInstance(this.cimHandle, cIMObjectPath2, cIMInstance2);
            Trace.trace("apcshscT", "<-createSmpPartition");
        }
        catch (Exception exception) {
            System.out.println(" Error while creating the SMP Partion");
            Trace.trace("apcshscT", "Error while creating the SMP Partion");
            exception.printStackTrace();
            HSCLogUtils.serverLog(exception, HSCLogUtils._CECClassLogInfo);
            this.cecInst.setProperty("state", new CIMValue((Object)new UnsignedInt8(253)));
            HscProviderUtils.handleCecInCompleteState(this.cimHandle, this.cecInst, this.cecInst, hscProviderSocket);
        }
    }

    private void createHscInfo(HscProviderSocket hscProviderSocket) {
        try {
            String string;
            String string2;
            CIMInstance cIMInstance;
            CIMClass cIMClass;
            CIMObjectPath cIMObjectPath;
            HSCVPD hSCVPD;
            CIMObjectPath cIMObjectPath2 = new CIMObjectPath("IBMHSC_LparManagement", "root/ibmhscV3_2");
            CIMClass cIMClass2 = this.cimHandle.getClass(cIMObjectPath2, false);
            Vector vector = CimomWrapper.enumInstances(this.cimHandle, cIMObjectPath2, false, cIMClass2, false);
            cIMObjectPath2 = null;
            if (vector != null && vector.size() != 0) {
                hSCVPD = (CIMInstance)vector.elementAt(0);
                cIMObjectPath2 = new CIMObjectPath(hSCVPD.getClassName(), hSCVPD.getKeyValuePairs());
                cIMObjectPath2.setNameSpace("root/ibmhscV3_2");
                System.out.println("the lparMgr obj path is ..." + cIMObjectPath2);
                cIMObjectPath = new CIMObjectPath("IBMHSC_ServiceManages", "root/ibmhscV3_2");
                cIMClass = this.cimHandle.getClass(cIMObjectPath, false);
                cIMInstance = cIMClass.newInstance();
                cIMInstance.setProperty("Service", new CIMValue((Object)cIMObjectPath2));
                cIMInstance.setProperty("Managed", new CIMValue((Object)this.cecObjPath));
                string2 = new CIMObjectPath(cIMInstance.getClassName(), cIMInstance.getKeyValuePairs());
                string2.setNameSpace("root/ibmhscV3_2");
                CimomWrapper.createInstance(this.cimHandle, (CIMObjectPath)string2, cIMInstance);
                System.out.println(" after the ServiceManages ass creation...");
            } else {
                System.out.println("Failed to create the service manager assocation creation.");
            }
            hSCVPD = new HSCVPD();
            string2 = null;
            String string3 = null;
            CIMObjectPath cIMObjectPath3 = null;
            cIMObjectPath = new CIMObjectPath("IBMHSC_HscInfo", "root/ibmhscV3_2");
            cIMClass = this.cimHandle.getClass(cIMObjectPath, false);
            if (hSCVPD.isVPDPresent()) {
                string2 = hSCVPD.getHSCModel();
                string3 = hSCVPD.getHSCSerialNumber();
                string = string2 + "*" + string3;
                if (string.length() > 31) {
                    string = string.substring(string.length() - 31);
                }
                cIMInstance = cIMClass.newInstance();
                cIMInstance.setProperty("ComputerSystemCreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
                cIMInstance.setProperty("ComputerSystemName", new CIMValue((Object)this.cecName));
                cIMInstance.setProperty("DataTag", new CIMValue((Object)"HscName"));
                cIMInstance.setProperty("Data", new CIMValue((Object)string));
                cIMInstance.setProperty("DataLength", new CIMValue((Object)new UnsignedInt16(string.length())));
                cIMObjectPath3 = new CIMObjectPath(cIMInstance.getClassName(), cIMInstance.getKeyValuePairs());
                cIMObjectPath3.setNameSpace("root/ibmhscV3_2");
                HscInfoInstProv.createHscInfo(cIMObjectPath3, cIMInstance, hscProviderSocket, this.cimHandle, true);
                System.out.println(" after the hscinfo  creation for HscName...");
            } else {
                System.out.println(" Failed to create the hsc info for hscname.. NO VPD Present..");
            }
            cIMInstance = cIMClass.newInstance();
            string = InetAddress.getLocalHost().getHostAddress();
            cIMInstance.setProperty("ComputerSystemCreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
            cIMInstance.setProperty("ComputerSystemName", new CIMValue((Object)this.cecName));
            cIMInstance.setProperty("DataTag", new CIMValue((Object)"HscIPAddr"));
            cIMInstance.setProperty("Data", new CIMValue((Object)string));
            if (string == null) {
                cIMInstance.setProperty("DataLength", new CIMValue((Object)new UnsignedInt16(0)));
            } else {
                cIMInstance.setProperty("DataLength", new CIMValue((Object)new UnsignedInt16(string.length())));
            }
            cIMObjectPath3 = new CIMObjectPath(cIMInstance.getClassName(), cIMInstance.getKeyValuePairs());
            cIMObjectPath3.setNameSpace("root/ibmhscV3_2");
            HscInfoInstProv.createHscInfo(cIMObjectPath3, cIMInstance, hscProviderSocket, this.cimHandle, true);
            System.out.println(" after the hscinfo  creation for ipaddress...");
            cIMInstance = cIMClass.newInstance();
            String string4 = InetAddress.getLocalHost().getHostName();
            cIMInstance.setProperty("ComputerSystemCreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
            cIMInstance.setProperty("ComputerSystemName", new CIMValue((Object)this.cecName));
            cIMInstance.setProperty("DataTag", new CIMValue((Object)"HscHostName"));
            cIMInstance.setProperty("Data", new CIMValue((Object)string4));
            if (string4 == null) {
                cIMInstance.setProperty("DataLength", new CIMValue((Object)new UnsignedInt16(0)));
            } else {
                cIMInstance.setProperty("DataLength", new CIMValue((Object)new UnsignedInt16(string4.length())));
            }
            cIMObjectPath3 = new CIMObjectPath(cIMInstance.getClassName(), cIMInstance.getKeyValuePairs());
            cIMObjectPath3.setNameSpace("root/ibmhscV3_2");
            HscInfoInstProv.createHscInfo(cIMObjectPath3, cIMInstance, hscProviderSocket, this.cimHandle, true);
            System.out.println(" after the hscinfo  creation for host name...");
        }
        catch (Throwable throwable) {
            System.out.println(" excp in creation of hsc info...");
            throwable.printStackTrace();
            HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
            this.cecInst.setProperty("state", new CIMValue((Object)new UnsignedInt8(253)));
            HscProviderUtils.handleCecInCompleteState(this.cimHandle, this.cecInst, this.cecInst, hscProviderSocket);
        }
    }

    private void pushHscInfo(HscProviderSocket hscProviderSocket) throws CIMException {
        try {
            Hashtable hashtable = null;
            String string = HscInfoMethProv.constructHscInfo((ProviderCIMOMHandle)this.cimHandle, this.cecName);
            System.out.println("++++++ push hsc info down to CSP: " + string);
            hashtable = HscProviderUtils.doCSPCommand("GET_NUMBER_HSC_INFO_SLOTS", null, hscProviderSocket);
            Integer n = (Integer)hashtable.get("CURRENT_HSC_SLOT");
            HscProviderUtils.doCSPCommand("SET_HSC_INFORMATION", new String[]{Integer.toHexString(n), Integer.toHexString(0), Integer.toString(string.length()), string}, hscProviderSocket);
            Exception exception = new Exception(string);
            HSCLogUtils.serverLog(exception, HSCLogUtils._HSCInfoClassLogInfo);
        }
        catch (Throwable throwable) {
            HSCLogUtils.serverLog(throwable, HSCLogUtils._HSCInfoClassLogInfo);
            if (!(throwable instanceof HSCCIMException)) {
                throw new HSCCIMException("1772");
            }
            throw new HSCCIMException(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isFastActivate(Short s, String string, HscProviderSocket hscProviderSocket) throws CIMException {
        Integer n = null;
        Integer n2 = null;
        String string2 = string;
        String string3 = null;
        Integer n3 = null;
        NVRAM nVRAM = null;
        Integer n4 = null;
        boolean bl = false;
        String string4 = "(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)";
        Hashtable hashtable = new Hashtable();
        String[] stringArray = new String[]{Integer.toHexString(s.shortValue())};
        try {
            try {
                Trace.trace("apcshscT", "-> isFastActivate");
                System.out.println(string4);
                System.out.println("Start isFastActivate....");
                try {
                    hashtable = HscProviderUtils.doCSPCommand("GET_CSP_INTERFACE_VERSION_NUMBER", null, hscProviderSocket);
                    string3 = (String)hashtable.get("VERSION");
                    hashtable = HscProviderUtils.doCSPCommand("GET_CEC_STATE", null, hscProviderSocket, string3);
                    n = (Integer)hashtable.get("CEC_STATE");
                    hashtable = HscProviderUtils.doCSPCommand("GET_CEC_CAPABILITY_MODE", null, hscProviderSocket, string3);
                    n2 = (Integer)hashtable.get("MODE");
                    if (n == null) {
                    }
                    if (n2 == null) {
                    }
                    if (n.shortValue() != 1) {
                    }
                    if (n2.shortValue() == 255) {
                        hashtable = HscProviderUtils.doCSPCommand("GET_LPAR_SLOT_DEFINITION_STATE", stringArray, hscProviderSocket, string3);
                        n4 = (Integer)hashtable.get("DEFINITION_STATE");
                        hashtable = HscProviderUtils.doCSPCommand("GET_LPAR_STATE", stringArray, hscProviderSocket, string3);
                        n3 = (Integer)hashtable.get("LPAR_STATE");
                        if (n4 != null && n3 != null && n4.shortValue() == 10 && n3.shortValue() == 1) {
                            try {
                                nVRAM = (NVRAM)NVRAM.NVRAM_TABLE.get(string2);
                                System.out.println("Hashtable : " + nVRAM + "For CEC: " + string2);
                                bl = nVRAM.getFastActivation(s.intValue(), hscProviderSocket);
                                System.out.println("%%%%%%%%%%%%%%%%% isFast from NVRAM = " + bl + " %%%%%%%%%%%%%%%%");
                            }
                            catch (Throwable throwable) {
                                throwable.printStackTrace();
                                System.out.println("++++++ excep in the nvram initilize ..");
                                boolean bl2 = false;
                                System.out.println("lparId = " + String.valueOf(s) + "\nFActivate Setting = " + String.valueOf(bl));
                                System.out.println("End of isFastActivate");
                                System.out.println(string4);
                                Trace.trace("apcshscT", "<- isFastActivate");
                                boolean bl3 = bl;
                                Object var20_19 = null;
                                Trace.trace("apcshscT", "<- isFastActivate");
                                return bl;
                            }
                        }
                        System.out.println("<<<<< Lpar " + s.intValue() + " not fast Activate.....or...>>>>>>>");
                        bl = false;
                        return bl;
                    }
                }
                finally {
                    System.out.println("lparId = " + String.valueOf(s) + "\nFActivate Setting = " + String.valueOf(bl));
                    System.out.println("End of isFastActivate");
                    System.out.println(string4);
                    Trace.trace("apcshscT", "<- isFastActivate");
                    boolean bl4 = bl;
                }
            }
            catch (Throwable throwable) {
                System.out.println("++++++ Exception caught in isFastActivate....");
                throwable.printStackTrace();
                HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                System.out.println("++++++ Returning false for partition " + String.valueOf(s));
                throw new HSCCIMException(throwable);
            }
        }
        catch (Throwable throwable) {
            Object var20_22 = null;
            Trace.trace("apcshscT", "<- isFastActivate");
            return bl;
        }
    }

    private void debugAddFastActivate(Short s) {
        String string = "(*)(*)(*)(*)DEBUG FAST ACTIVATE(*)(*)(*)(*)(*)";
        System.out.println();
        System.out.println(string);
        System.out.println("Adding lparId = " + String.valueOf(s) + "to fastActivateVector...");
        System.out.println(string);
        System.out.println();
    }

    private void resetAsyncEventMask(HscProviderSocket hscProviderSocket) {
        Object var2_2 = null;
        try {
            HscProviderUtils.doCSPCommand("SET_EVENT_NOTIFICATION_HANDLER_SETTINGS", new String[]{Integer.toString(16127), "0"}, hscProviderSocket);
        }
        catch (Throwable throwable) {
            HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
            throwable.printStackTrace();
        }
    }
}

